/**
 * Creates the string for a simple request
 * @param command Request command
 * @param path Path of the selected file
 */
export function SimpleReq(command:string, path:string):string{
    return "{"+command+", \""+ path +"\"}.\n";
}

/**
 * Creates the string for a transform request
 * @param command Request command
 * @param path Path of the selected file
 * @param ExtraArgs Position arguments if received none otherwise
 */
export function TransformReq(command:string, path:string, ExtraArgs:string = ""):string{
    let args = command !== "clustering" ? ", {file, \"" + path + "\"}" + ExtraArgs : "";
    return "{transform, "+command+", [{ask_missing, true}"+args+"]}.\n";
}

/**
 * Creates the string for a duplicate code search
 * @param Type Selected search algorithm
 * @param path Path of the selected file
 * @param StartPos Starting position of the search
 * @param EndPos Ending position of the search
 */
export function DuplicateCodeReq(Type:string, path:string, StartPos:number, EndPos:number):string{
    return "{clone_identifierl_by_pos, "+Type+", \"" + path + "\", "+StartPos+", "+EndPos+", linecol, ui_format}.\n";
}

/**
 * Creates the string for a semantic query request
 * @param querystr query string
 * @param path Path of the selected file
 * @param ExtraArgs Position arguments if received none otherwise
 */
export function SemQuery(querystr:string, path:string="", ExtraArgs:string = ""):string{
    return "{transform, semantic_query, [{querystr, \""+querystr+"\"},"+
            "{start_opt, [{ask_missing, false}, {file, \""+path+"\"}" + ExtraArgs + "]},"+
            "{display_opt, [{positions,scalar},{output,msg}]}]}.\n";
}

/**
 * Creates the string for a metric query request
 * @param querystr query string
 */
export function MetricQuery(querystr:string){
    return "{transform, metric_query, [{querys, \""+querystr+"\"}]}.\n";
}

/**
 * Creates the string for a dependence analysis
 * @param level Level of search
 * @param type Output type
 * @param start_mods Starting nodes for the search
 * @param dotpath In case of smart graph output, path of the dot file to create
 */
export function DepGraphReq(level:string, type:string, start_mods:string, dotpath:string):string{
    let sn = start_mods.trim() === "" ? "" : "{starting_nodes,"+JSON.stringify(start_mods.split(",").map(s => s.trim()))+"},";
    let lev = level === "Module" ? "mod" : "func";
    let out = type === "Plain Text" ? "{output,name_terms}" : "{file_path,\""+dotpath+"\"}";
    return "{draw_dep_graph,["+sn+"{level,"+lev+"},{type,all},"+out+"]}.\n";
}