/* 
-*- coding: latin-1 -*-

This file is part of RefactorErl.

RefactorErl is free software: you can redistribute it and/or modify
it under the terms of the GNU Lesser General Public License as published
by the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

RefactorErl is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public License
along with RefactorErl.  If not, see <http://plc.inf.elte.hu/erlang/>.

The Original Code is RefactorErl.

The Initial Developer of the Original Code is Eötvös Loránd University.
Portions created  by Eötvös Loránd University and ELTE-Soft Ltd.
are Copyright 2007-2025 Eötvös Loránd University, ELTE-Soft Ltd.
and Ericsson Hungary. All Rights Reserved.
*/

package com.refactorerl.ui.presentation.queries;

import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.part.ViewPart;

import com.refactorerl.ui.logic.queries.QueryResultElement;
import com.refactorerl.ui.presentation.codebrowser.ShowFileDoubleClickListener;

public class QueryResultView extends ViewPart {

	Label label;
	TreeViewer treeViewer;

	public void setInput(Object input) {

		// label.setText("input");
		// label.setText(input.toString());
		treeViewer.setInput(input);
		treeViewer.expandAll();
	}

	@Override
	public void createPartControl(Composite parent) {

		// label = new Label(parent, SWT.SINGLE | SWT.BORDER);
		// label.setText("hello");

		treeViewer = new TreeViewer(parent);
		treeViewer.setContentProvider(new QueryResultContentProvider());

		treeViewer.setLabelProvider(new LabelProvider() {
			@Override
			public String getText(Object element) {
				String s;
				if (element instanceof String)
					s = (String) element;
				else if (element instanceof QueryResultElement)
					s = ((QueryResultElement) element).getValue();
				else
					s = element.toString();

				s = s.replaceAll("^\"|\"$", ""); //$NON-NLS-1$ //$NON-NLS-2$

				return s;
			}

		});

		treeViewer.addDoubleClickListener(new ShowFileDoubleClickListener(parent, getViewSite()));
		
		treeViewer.setInput(null);

		treeViewer.expandAll();
		

		MenuManager menuManager = new MenuManager();
		Menu menu = menuManager.createContextMenu(treeViewer.getControl());
		treeViewer.getControl().setMenu(menu);
		getSite().registerContextMenu(menuManager, treeViewer);
		getSite().setSelectionProvider(treeViewer);
		
	}

	@Override
	public void setFocus() {

	}
	
	@Override
	public void setPartName(String partName){
		super.setPartName(partName);
	}

}
