/* 
-*- coding: latin-1 -*-

This file is part of RefactorErl.

RefactorErl is free software: you can redistribute it and/or modify
it under the terms of the GNU Lesser General Public License as published
by the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

RefactorErl is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public License
along with RefactorErl.  If not, see <http://plc.inf.elte.hu/erlang/>.

The Original Code is RefactorErl.

The Initial Developer of the Original Code is Eötvös Loránd University.
Portions created  by Eötvös Loránd University and ELTE-Soft Ltd.
are Copyright 2007-2025 Eötvös Loránd University, ELTE-Soft Ltd.
and Ericsson Hungary. All Rights Reserved.
*/

package com.refactorerl.ui.presentation.queries;

import java.util.Iterator;
import java.util.List;

import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.part.ViewPart;

import com.refactorerl.ui.logic.queries.QueryHistoryElement;

public class QueryHistoryView extends ViewPart {

	private ListViewer viewer;

	public void setInput(List<QueryHistoryElement> input) {
		viewer.setInput(input);
	}

	@Override
	public void createPartControl(Composite parent) {
		viewer = new ListViewer(parent);

		viewer.setContentProvider(new IStructuredContentProvider() {

			private List<QueryHistoryElement> input;

			@Override
			public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
				//
				this.input = (List<QueryHistoryElement>) newInput;
			}

			@Override
			public void dispose() {
			
			}

			@Override
			public Object[] getElements(Object inputElement) {
				return input.toArray();
			}
		});

		viewer.setLabelProvider(new LabelProvider());

		viewer.addDoubleClickListener(new IDoubleClickListener() {

			@Override
			public void doubleClick(DoubleClickEvent event) {

				if (viewer.getSelection() == null)
					return;

				IStructuredSelection sSelection = (IStructuredSelection) viewer.getSelection();

				Iterator it = sSelection.iterator();

				while (it.hasNext()) {
					QueryHistoryElement el = (QueryHistoryElement) it.next();
					QueryHandler.showQueryResults(el.queryString, getSite().getWorkbenchWindow(), el.queryResults);

				}

				// QueryHandler.showQueryResults(, wb, result);

			}
		});

	}

	@Override
	public void setFocus() {
	
	}

}
