/* 
-*- coding: latin-1 -*-

This file is part of RefactorErl.

RefactorErl is free software: you can redistribute it and/or modify
it under the terms of the GNU Lesser General Public License as published
by the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

RefactorErl is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public License
along with RefactorErl.  If not, see <http://plc.inf.elte.hu/erlang/>.

The Original Code is RefactorErl.

The Initial Developer of the Original Code is Eötvös Loránd University.
Portions created  by Eötvös Loránd University and ELTE-Soft Ltd.
are Copyright 2007-2025 Eötvös Loránd University, ELTE-Soft Ltd.
and Ericsson Hungary. All Rights Reserved.
*/

package com.refactorerl.ui.presentation.queries;

import java.util.List;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.handlers.HandlerUtil;

import com.refactorerl.ui.logic.queries.QueryHistoryElement;
import com.refactorerl.ui.logic.queries.QueryHistoryRequest;
import com.refactorerl.ui.presentation.Activator;

public class QueryHistoryHandler extends AbstractHandler {

	@Override
	public Object execute(ExecutionEvent event) {
		IWorkbenchWindow activeWorkbenchWindow = HandlerUtil.getActiveWorkbenchWindow(event);
		IWorkbenchPage activePage = activeWorkbenchWindow.getActivePage();
		try {

			QueryHistoryView view = (QueryHistoryView) activePage.showView("com.refactorerl.ui.queryHistoryView", //$NON-NLS-1$
					"1", IWorkbenchPage.VIEW_ACTIVATE); //$NON-NLS-1$

			final List<QueryHistoryElement> request = Activator.executeRequest(
					new QueryHistoryRequest(Activator.getProxy(), null), HandlerUtil.getActiveWorkbenchWindow(event)
							.getShell());
			if (request == null)
				return null;

			view.setInput(request);

			view.setFocus();

		} catch (PartInitException e) {
			Activator.showErrorDialog(e, HandlerUtil.getActiveWorkbenchWindow(event).getShell());
		}

		return null;
	}

}
