/* 
-*- coding: latin-1 -*-

This file is part of RefactorErl.

RefactorErl is free software: you can redistribute it and/or modify
it under the terms of the GNU Lesser General Public License as published
by the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

RefactorErl is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public License
along with RefactorErl.  If not, see <http://plc.inf.elte.hu/erlang/>.

The Original Code is RefactorErl.

The Initial Developer of the Original Code is Eötvös Loránd University.
Portions created  by Eötvös Loránd University and ELTE-Soft Ltd.
are Copyright 2007-2025 Eötvös Loránd University, ELTE-Soft Ltd.
and Ericsson Hungary. All Rights Reserved.
*/

package com.refactorerl.ui.presentation.queries;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class QueryDialog extends Dialog {

	private String dialogTitle;
	private String dialogMessage;

	public QueryDialog(Shell parentShell, String dialogTitle, String dialogMessage) {
		super(parentShell);
		this.dialogMessage = dialogMessage;
	}

	private Text valueText;
	private String value;

	@Override
	protected Control createDialogArea(Composite parent) {
		Composite area = new Composite(parent, SWT.NONE);//(Composite) super.createDialogArea(parent);

		area.setLayout(new GridLayout(1, false));

		Label label = new Label(area, SWT.NONE);
		label.setText(dialogMessage);
		label.setLayoutData(new GridData(SWT.FILL, SWT.BEGINNING, true, false));
		
		valueText = new Text(area, SWT.BORDER);
		valueText.setLayoutData(new GridData(SWT.FILL,SWT.BEGINNING, true, false));
		ContentProposalAdapter autocomplete = new QueryContentProposalAdapter(valueText); 

		return area;
	}

	@Override
	protected void okPressed() {

		value = valueText.getText();

		super.okPressed();
	}

	public String getValue() {
		return value;
	}

}
