/* 
-*- coding: latin-1 -*-

This file is part of RefactorErl.

RefactorErl is free software: you can redistribute it and/or modify
it under the terms of the GNU Lesser General Public License as published
by the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

RefactorErl is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public License
along with RefactorErl.  If not, see <http://plc.inf.elte.hu/erlang/>.

The Original Code is RefactorErl.

The Initial Developer of the Original Code is Eötvös Loránd University.
Portions created  by Eötvös Loránd University and ELTE-Soft Ltd.
are Copyright 2007-2025 Eötvös Loránd University, ELTE-Soft Ltd.
and Ericsson Hungary. All Rights Reserved.
*/

package com.refactorerl.ui.presentation.queries;

import java.util.List;

import org.eclipse.jface.fieldassist.ContentProposal;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.swt.widgets.Control;

import com.refactorerl.ui.common.Pair;
import com.refactorerl.ui.logic.queries.QueryAutoCompleteRequest;
import com.refactorerl.ui.presentation.Activator;

/**
 * This can be used to add auto-completion support to Text widgets. 
 * @author Daniel Lukacs, 2014 ELTE IK
 *
 */
public class QueryContentProposalAdapter extends ContentProposalAdapter {

	public QueryContentProposalAdapter(final Control control) {

		super(control, new TextContentAdapter(), new IContentProposalProvider() {

			@Override
			public IContentProposal[] getProposals(String contents, int position) {

				if (contents == null || contents.trim().length() < 1)
					return null;

				List<Pair<String, String>> propStrings = Activator.executeRequest(new QueryAutoCompleteRequest(
						contents, Activator.getProxy(), null), control.getParent().getShell(), true);
				if (propStrings == null || propStrings.isEmpty())
					return new IContentProposal[0];

				ContentProposal[] props = new ContentProposal[propStrings.size()];
				int i = 0;
				for (Pair<String, String> s : propStrings) {
					props[i] = new ContentProposal(s.value, s.key + s.value, null);
					++i;
				}

				return props;

			}
		}, null, null);

	}

}
