/* 
-*- coding: latin-1 -*-

This file is part of RefactorErl.

RefactorErl is free software: you can redistribute it and/or modify
it under the terms of the GNU Lesser General Public License as published
by the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

RefactorErl is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public License
along with RefactorErl.  If not, see <http://plc.inf.elte.hu/erlang/>.

The Original Code is RefactorErl.

The Initial Developer of the Original Code is Eötvös Loránd University.
Portions created  by Eötvös Loránd University and ELTE-Soft Ltd.
are Copyright 2007-2025 Eötvös Loránd University, ELTE-Soft Ltd.
and Ericsson Hungary. All Rights Reserved.
*/

package com.refactorerl.ui.presentation.investigations;

import java.util.List;

import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

import com.refactorerl.ui.presentation.GeneralContentProposalAdapter;

public class NewEmptyInvestigationDialog extends TitleAreaDialog{

	private String title;
	private List<String> proposals;
	private String message;
	private Text nameText;
	private Text funText;
	
	private String name;
	private String fun;
	
	public NewEmptyInvestigationDialog(Shell parentShell, String title, String message, List<String> proposals) {
		super(parentShell);
		this.title = title;
		this.message = message;
		this.proposals = proposals;
	}

	
	
	@Override
	protected Control createDialogArea(Composite parent) {
		final Composite area = (Composite)super.createDialogArea(parent);
		Composite cmp = new Composite(area, SWT.NONE);
		GridLayout layout = new GridLayout(2, false);		
		cmp.setLayout(layout);

		setTitle(title);
		setMessage(message);
		
		new Label(cmp, SWT.NONE).setText(Messages.NewEmptyInvestigationDialog_0);
		nameText = new Text(cmp, SWT.BORDER);
		nameText.setLayoutData(new GridData(SWT.FILL, SWT.BEGINNING, true, false));
		new Label(cmp, SWT.NONE).setText(Messages.NewEmptyInvestigationDialog_1);
		funText = new Text(cmp, SWT.BORDER);
		funText.setLayoutData(new GridData(SWT.FILL, SWT.BEGINNING, true, false));
		new GeneralContentProposalAdapter(funText, proposals);		
		
		return area;

	}
	
	@Override
	protected void okPressed() {
		name = nameText.getText();
		fun = funText.getText();
		super.okPressed();
	}
	
	public String getInvestigationName(){
		return name;
	}
	public String getStartFunction(){
		return fun;
	}
	
	
}
