/* 
-*- coding: latin-1 -*-

This file is part of RefactorErl.

RefactorErl is free software: you can redistribute it and/or modify
it under the terms of the GNU Lesser General Public License as published
by the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

RefactorErl is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public License
along with RefactorErl.  If not, see <http://plc.inf.elte.hu/erlang/>.

The Original Code is RefactorErl.

The Initial Developer of the Original Code is Eötvös Loránd University.
Portions created  by Eötvös Loránd University and ELTE-Soft Ltd.
are Copyright 2007-2025 Eötvös Loránd University, ELTE-Soft Ltd.
and Ericsson Hungary. All Rights Reserved.
*/

package com.refactorerl.ui.presentation.investigations;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.services.IServiceLocator;

import com.refactorerl.ui.logic.investigations.GetInvestigationsListRequest;
import com.refactorerl.ui.presentation.Activator;

/**
 * Hosts the list of investigations and opens a new editor on the investigation
 * selected by the user
 * 
 * @author Daniel Lukacs, 2014 ELTE IK
 *
 */
public class InvestigationsView extends ViewPart {

	private Composite parent;
	private ListViewer viewer;

	@Override
	public void createPartControl(Composite parent) {
		this.parent = parent;
		viewer = new ListViewer(parent);

		viewer.setContentProvider(new IStructuredContentProvider() {

			private List<String> input;

			@Override
			public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
				this.input = (List<String>) newInput;
			}

			@Override
			public void dispose() {

			}

			@Override
			public Object[] getElements(Object inputElement) {
				return input.toArray();
			}
		});

		viewer.setLabelProvider(new LabelProvider());

		viewer.addDoubleClickListener(new IDoubleClickListener() {
			@Override
			public void doubleClick(DoubleClickEvent event) {

				if (viewer.getSelection() == null)
					return;

				IStructuredSelection sSelection = (IStructuredSelection) viewer.getSelection();

				Iterator it = sSelection.iterator();

				while (it.hasNext()) {
					String el = (String) it.next();
					openEditor(el);

				}
			}
		});

		refreshList();

		MenuManager menuManager = new MenuManager();

		Menu menu = menuManager.createContextMenu(viewer.getControl());

		viewer.getControl().setMenu(menu);
		getSite().registerContextMenu(menuManager, viewer);
		getSite().setSelectionProvider(viewer);

	}

	public void refreshList() {
		List<String> invs = Activator.executeRequest(new GetInvestigationsListRequest(Activator.getProxy(), null),
				parent.getShell());

		viewer.setInput(invs);

	}

	private void openEditor(String name) {

		IServiceLocator serviceLocator = PlatformUI.getWorkbench();
		ICommandService commandService = (ICommandService) serviceLocator.getService(ICommandService.class);
		Command command = commandService.getCommand("com.refactorerl.ui.modifyInvestigation"); //$NON-NLS-1$
		try {
			Map<String, String> parameters = new HashMap<>();
			parameters.put("com.refactorerl.ui.modifyInvestigation.mode", "load"); //$NON-NLS-1$ //$NON-NLS-2$
			parameters.put("com.refactorerl.ui.modifyInvestigation.name", name); //$NON-NLS-1$

			command.executeWithChecks(new ExecutionEvent(command, parameters, this, null));
		} catch (ExecutionException | NotDefinedException | NotEnabledException | NotHandledException e1) {

		}

	}

	@Override
	public void setFocus() {
	
	}

	@Override
	public void dispose() {
		super.dispose();
	}

}
