/* 
-*- coding: latin-1 -*-

This file is part of RefactorErl.

RefactorErl is free software: you can redistribute it and/or modify
it under the terms of the GNU Lesser General Public License as published
by the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

RefactorErl is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public License
along with RefactorErl.  If not, see <http://plc.inf.elte.hu/erlang/>.

The Original Code is RefactorErl.

The Initial Developer of the Original Code is Eötvös Loránd University.
Portions created  by Eötvös Loránd University and ELTE-Soft Ltd.
are Copyright 2007-2025 Eötvös Loránd University, ELTE-Soft Ltd.
and Ericsson Hungary. All Rights Reserved.
*/

package com.refactorerl.ui.presentation.investigations;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPersistableElement;

import com.refactorerl.ui.logic.investigations.Investigation;

/**Wrapper */
public class InvestigationEditorInput implements IEditorInput{

	public final Investigation input;

	
	public InvestigationEditorInput(Investigation investigation) {
		super();
		this.input = investigation;

	}
	
	@Override
	public boolean equals(Object obj) {
	
		if(!(obj instanceof InvestigationEditorInput)) return false;
		InvestigationEditorInput other = (InvestigationEditorInput) obj;
		if(input == null && other.input == null) return true;
		if(input == null) return false;
		if(other.input == null) return false;
		
		return input.getName().equals(other.input.getName());
	}

	@Override
	public Object getAdapter(Class adapter) {
		
		return null;
	}

	@Override
	public boolean exists() {
		
		return false;
	}

	@Override
	public ImageDescriptor getImageDescriptor() {
		
		return null;
	}

	@Override
	public String getName() {
		
		return null;
	}

	@Override
	public IPersistableElement getPersistable() {
		
		return null;
	}

	@Override
	public String getToolTipText() {
		
		return null;
	}
	
}
