/* 
-*- coding: latin-1 -*-

This file is part of RefactorErl.

RefactorErl is free software: you can redistribute it and/or modify
it under the terms of the GNU Lesser General Public License as published
by the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

RefactorErl is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public License
along with RefactorErl.  If not, see <http://plc.inf.elte.hu/erlang/>.

The Original Code is RefactorErl.

The Initial Developer of the Original Code is Eötvös Loránd University.
Portions created  by Eötvös Loránd University and ELTE-Soft Ltd.
are Copyright 2007-2025 Eötvös Loránd University, ELTE-Soft Ltd.
and Ericsson Hungary. All Rights Reserved.
*/

package com.refactorerl.ui.presentation.filelist;

import java.util.List;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeNode;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.part.ViewPart;

import com.refactorerl.ui.logic.filelist.FileListRequest;
import com.refactorerl.ui.presentation.Activator;
import com.refactorerl.ui.presentation.codebrowser.ShowFileDoubleClickListener;

public class FileListView extends ViewPart {
	private Composite parent;
	private TreeViewer v;

	private List<String> input;
	private Menu menu;

	@Override
	public void createPartControl(Composite parent) {
		this.parent = parent;
		v = new TreeViewer(parent);

		v.setContentProvider(new FileListContentProvider());

		v.setLabelProvider(new LabelProvider() {
			@Override
			public String getText(Object element) {
				return ((FileListContentProvider.PathNamePair) ((TreeNode) element).getValue()).name;
			}

		});

		v.addDoubleClickListener(new ShowFileDoubleClickListener(parent, getViewSite()));

		MenuManager menuManager = new MenuManager();
		menu = menuManager.createContextMenu(v.getControl());
		v.getControl().setMenu(menu);
		getSite().registerContextMenu(menuManager, v);
		getSite().setSelectionProvider(v);

		if(Activator.isStarted())
			reload();

	}

	@Override
	public void showBusy(final boolean busy) {
		super.showBusy(busy);
		getSite().getShell().getDisplay().syncExec(new Runnable() {
			@Override
			public void run() {
				Activator.showBusy(parent, busy);

				// Eclipse bug: will possibly disable the system window manager:
				// menu.setEnabled(!busy);
			}
		});

	}

	public void reload() {
		new Job(Messages.FileListView_0) {

			@Override
			protected IStatus run(IProgressMonitor monitor) {
				if (Activator.isStarted())
						showBusy(true);

						input = Activator.executeRequest(new FileListRequest(Activator.getProxy(), null), getSite().getShell());
						
						if(input == null) return Status.CANCEL_STATUS;
						
						getSite().getShell().getDisplay().syncExec(new Runnable() {
							@Override
							public void run() {
								v.setInput(input);
								v.expandAll();

								showBusy(false);
							}
						});

				return Status.OK_STATUS;
			}

		}.schedule();

	}

	@Override
	public void setFocus() {

	}

}
