/* 
-*- coding: latin-1 -*-

This file is part of RefactorErl.

RefactorErl is free software: you can redistribute it and/or modify
it under the terms of the GNU Lesser General Public License as published
by the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

RefactorErl is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public License
along with RefactorErl.  If not, see <http://plc.inf.elte.hu/erlang/>.

The Original Code is RefactorErl.

The Initial Developer of the Original Code is Eötvös Loránd University.
Portions created  by Eötvös Loránd University and ELTE-Soft Ltd.
are Copyright 2007-2025 Eötvös Loránd University, ELTE-Soft Ltd.
and Ericsson Hungary. All Rights Reserved.
*/

package com.refactorerl.ui.presentation.filelist;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeNode;
import org.eclipse.jface.viewers.Viewer;

/**
 * 
 * @author Daniel Lukacs, 2014 ELTE IK
 *
 */
public class FileListContentProvider implements ITreeContentProvider {

	@Override
	public void dispose() {

	}

	private Viewer viewer;
	private TreeNode root;
	List<String> fileList;

	@Override
	public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {

		this.viewer = viewer;

		if (newInput == null)
			return;

		List<String> newFileList = (List<String>) newInput;

		root = pathsToTreeNode(newFileList);

		fileList = newFileList;

		// if (root == null) {
		// root = pathsToTreeNode(newFileList);
		// fileList = newFileList;
		// } else {
		// newFileList.removeAll(fileList);
		// for (String path : newFileList) {
		// insertPathToTree(root, path);
		// }
		// fileList.addAll(newFileList);
		// }
		//

	}

	public static class PathNamePair {
		final public String name;
		final public String path;

		public PathNamePair(String path, String name) {
			super();
			this.name = name;
			this.path = path;
		}

		@Override
		public boolean equals(Object obj) {
			if (!(obj instanceof PathNamePair))
				return false;
			PathNamePair other = (PathNamePair) obj;
			return other.name.equals(name) && other.path.equals(path);
		}

	}

	private TreeNode pathsToTreeNode(List<String> paths) {
		if (paths.isEmpty())
			return null;

		// PSEUDOCODE

		// create Root("whatever");
		// for each (Path in Pathlist){
		// Current = Root;
		// for each (Segment in Path.segments()){
		// create TemporaryNode(Path.segmentsUpTo(Segment))
		// if (Current.children().containsChildWithSameValueAs(TemporaryNode)){
		// Current = Current.childWithSameValueAs(TemporaryNode); //
		// continue; // to the next Segment
		// } else {
		// Current.add(TemporaryNode);
		// Current = TemporaryNode;
		// }
		// }

		// }

		TreeNode root = new TreeNode(new PathNamePair("", "")); //$NON-NLS-1$ //$NON-NLS-2$
		root.setChildren(new TreeNode[0]);

		for (String path0 : paths) {
			insertPathToTree(root, path0);

		}

		return root;
	}

	private void insertPathToTree(TreeNode root, String path0) {
		TreeNode current = root;

		IPath path = new Path(path0);

		int segmentIndex = 1;
		for (String segment : path.segments()) {

			TreeNode segmentNode = new TreeNode(new PathNamePair(path.uptoSegment(segmentIndex).toString(), segment));
			++segmentIndex;

			segmentNode.setChildren(new TreeNode[0]);

			TreeNode[] children = current.getChildren();

			if (children != null) {
				boolean found = false;
				for (TreeNode child : children) {

					if (child.equals(segmentNode)) {
						current = child;
						found = true;

						break; // children
					}
				}
				if (found)
					continue; // segments

			}
			List<TreeNode> newChildren;
			if (children != null)

				newChildren = new ArrayList<>(Arrays.asList(children));
			else
				newChildren = new ArrayList<>();// not used

			newChildren.add(segmentNode);
			current.setChildren(newChildren.toArray(new TreeNode[newChildren.size()]));

			current = segmentNode;

		}
	}

	@Override
	public Object[] getElements(Object inputElement) {
		if (root != null) {
			return root.getChildren();
		}

		return new TreeNode[0];

	}

	@Override
	public Object[] getChildren(Object parentElement) {
		if (parentElement instanceof TreeNode)
			return ((TreeNode) parentElement).getChildren();

		return null;

	}

	@Override
	public Object getParent(Object element) {
		if (element instanceof TreeNode)
			if (!element.equals(root))
				return ((TreeNode) element).getParent();
		return null;
	}

	@Override
	public boolean hasChildren(Object element) {
		if (element instanceof TreeNode)
			return ((TreeNode) element).hasChildren();
		return false;
	}

}
