/* 
-*- coding: latin-1 -*-

This file is part of RefactorErl.

RefactorErl is free software: you can redistribute it and/or modify
it under the terms of the GNU Lesser General Public License as published
by the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

RefactorErl is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public License
along with RefactorErl.  If not, see <http://plc.inf.elte.hu/erlang/>.

The Original Code is RefactorErl.

The Initial Developer of the Original Code is Eötvös Loránd University.
Portions created  by Eötvös Loránd University and ELTE-Soft Ltd.
are Copyright 2007-2025 Eötvös Loránd University, ELTE-Soft Ltd.
and Ericsson Hungary. All Rights Reserved.
*/

package com.refactorerl.ui.presentation.filelist;

import java.util.List;

import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.part.ViewPart;

import com.refactorerl.ui.common.Pair;
import com.refactorerl.ui.logic.filelist.GetEnvsRequest;
import com.refactorerl.ui.presentation.Activator;
/**
 * 
 * @author Daniel Lukacs, 2014 ELTE IK
 *
 */
public class EnvsView extends ViewPart {

	private TableViewer v;
	List<Pair<String, String>> result = null;
	Composite parent;

	@Override
	public void createPartControl(Composite parent) {
		this.parent = parent;
		v = createTableViewer(parent);
		v.setContentProvider(new IStructuredContentProvider() {

			List<Pair<String, String>> input;

			@Override
			public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
				input = (List<Pair<String, String>>) newInput;
			}

			@Override
			public void dispose() {

			}

			@Override
			public Object[] getElements(Object inputElement) {
				return input.toArray();

			}
		});

		v.setLabelProvider(new ITableLabelProvider() {

			@Override
			public void removeListener(ILabelProviderListener listener) {
			}

			@Override
			public boolean isLabelProperty(Object element, String property) {
				return false;
			}

			@Override
			public void dispose() {

			}

			@Override
			public void addListener(ILabelProviderListener listener) {

			}

			@Override
			public String getColumnText(Object element, int columnIndex) {
				Pair<String, String> row = (Pair<String, String>) element;

				switch (columnIndex) {
				case 0:
					return row.key;

				case 1:
					return row.value;
				}

				return null;
			}

			@Override
			public Image getColumnImage(Object element, int columnIndex) {
				return null;
			}
		});

		MenuManager menuManager = new MenuManager();
		Menu menu = menuManager.createContextMenu(v.getControl());
		v.getControl().setMenu(menu);
		getSite().registerContextMenu(menuManager, v);
		getSite().setSelectionProvider(v);

		reloadWithUI();
	}

	public void reload() {
		result = Activator.executeRequest(new GetEnvsRequest(Activator.getProxy(), null), getSite().getShell());
		v.setInput(result);
		v.refresh(); // FIXME doesnt work
	}

	private void reloadWithUI() {

		result = Activator.executeRequest(new GetEnvsRequest(Activator.getProxy(), null), getSite().getShell());

		getSite().getShell().getDisplay().syncExec(new Runnable() {
			@Override
			public void run() {
				v.setInput(result);
				v.refresh(); // FIXME doesnt work
			}
		});

	}

	private TableViewer createTableViewer(Composite parent) {

		Composite container = new Composite(parent, SWT.NONE);
		container.setLayout(new GridLayout(1, false));

		// Create the composite
		Composite composite = new Composite(container, SWT.NONE);
		composite.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1));
		TableColumnLayout layout = new TableColumnLayout();
		composite.setLayout(layout);

		TableViewer tableViewer = new TableViewer(composite, SWT.BORDER | SWT.FULL_SELECTION);
		tableViewer.setUseHashlookup(true);

		tableViewer.getTable().setHeaderVisible(true);
		tableViewer.getTable().setLinesVisible(true);

		TableViewerColumn tableViewerColumn = new TableViewerColumn(tableViewer, SWT.NONE);
		TableColumn tblclmnFirst = tableViewerColumn.getColumn();
		layout.setColumnData(tblclmnFirst, new ColumnWeightData(2, ColumnWeightData.MINIMUM_WIDTH, true));
		tblclmnFirst.setText(Messages.EnvsView_0);

		TableViewerColumn tableViewerColumn_1 = new TableViewerColumn(tableViewer, SWT.NONE);
		TableColumn tblclmnLast = tableViewerColumn_1.getColumn();
		// Specify width using weights
		layout.setColumnData(tblclmnLast, new ColumnWeightData(2, ColumnWeightData.MINIMUM_WIDTH, true));
		tblclmnLast.setText(Messages.EnvsView_1);

		return tableViewer;
	}

	@Override
	public void setFocus() {

	}
}
