/* 
-*- coding: latin-1 -*-

This file is part of RefactorErl.

RefactorErl is free software: you can redistribute it and/or modify
it under the terms of the GNU Lesser General Public License as published
by the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

RefactorErl is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public License
along with RefactorErl.  If not, see <http://plc.inf.elte.hu/erlang/>.

The Original Code is RefactorErl.

The Initial Developer of the Original Code is Eötvös Loránd University.
Portions created  by Eötvös Loránd University and ELTE-Soft Ltd.
are Copyright 2007-2025 Eötvös Loránd University, ELTE-Soft Ltd.
and Ericsson Hungary. All Rights Reserved.
*/

package com.refactorerl.ui.presentation.filelist;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeNode;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.handlers.HandlerUtil;

import com.refactorerl.ui.logic.filelist.DropFileRequest;
import com.refactorerl.ui.presentation.Activator;

/**
 * 
 * @author Daniel Lukacs, 2014 ELTE IK
 *
 */
public class DropFileHandler extends AbstractHandler {

	@Override
	public Object execute(ExecutionEvent event) throws ExecutionException {

		IWorkbenchPage activePage = HandlerUtil.getActiveWorkbenchWindow(event).getActivePage();
		Shell shell = activePage.getActivePart().getSite().getShell();

		String pathParam = event.getParameter("com.refactorerl.ui.dropFile.path"); //$NON-NLS-1$

		List<String> filepaths = new LinkedList<>();

		if (pathParam != null && !pathParam.isEmpty()) {
			filepaths.add(pathParam);

		} else {

			ISelection selection = activePage.getSelection();

			if (selection == null || selection.isEmpty() || !(selection instanceof IStructuredSelection))
				return null;

			IStructuredSelection sSelection = (IStructuredSelection) selection;
			Iterator it = sSelection.iterator();

			final StringBuilder sb = new StringBuilder();
			while (it.hasNext()) {
				// String str = it.next().toString();
				Object nx = it.next();
				String str = ""; //$NON-NLS-1$
				if (nx instanceof TreeNode)
					str = ((FileListContentProvider.PathNamePair) ((TreeNode) nx).getValue()).path;
				else
					str = "??"; // TODO error //$NON-NLS-1$

				filepaths.add(str);
				sb.append(str + "\n"); //$NON-NLS-1$
			}

			
			MessageDialog md = new MessageDialog(shell, Messages.DropFileHandler_4, null, Messages.DropFileHandler_5,
					MessageDialog.QUESTION, new String[] { Messages.DropFileHandler_6, Messages.DropFileHandler_7 }, 0) {
				@Override
				protected Control createCustomArea(Composite parent) {
					super.createCustomArea(parent);
					Text t = new Text(parent, SWT.MULTI | SWT.BORDER);

					t.setText(sb.toString());
					t.setEditable(false);
					return t;

				}
			};
			int answ = md.open();
			if (answ == 1)
				return null;
		}

		for (String f : filepaths) {

			Activator.executeRequest(new DropFileRequest(f, Activator.getProxy(), null), HandlerUtil
					.getActiveWorkbenchWindow(event).getShell());

			final FileListView view = (FileListView) HandlerUtil.getActiveWorkbenchWindow(event).getActivePage()
					.findView("com.refactorerl.ui.fileListView"); //$NON-NLS-1$
			if (view != null)
				view.reload();

		}

		return null;
	}
}
