/* 
-*- coding: latin-1 -*-

This file is part of RefactorErl.

RefactorErl is free software: you can redistribute it and/or modify
it under the terms of the GNU Lesser General Public License as published
by the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

RefactorErl is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public License
along with RefactorErl.  If not, see <http://plc.inf.elte.hu/erlang/>.

The Original Code is RefactorErl.

The Initial Developer of the Original Code is Eötvös Loránd University.
Portions created  by Eötvös Loránd University and ELTE-Soft Ltd.
are Copyright 2007-2025 Eötvös Loránd University, ELTE-Soft Ltd.
and Ericsson Hungary. All Rights Reserved.
*/

package com.refactorerl.ui.presentation.filelist;

import java.util.Arrays;
import java.util.Iterator;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.commands.Parameterization;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.services.IServiceLocator;

import com.refactorerl.ui.presentation.Activator;

/**
 * This command can be executed with the Platform when there was a change (new
 * file added or existing file deleted) in a Workspace resource.
 * 
 * @author Daniel Lukacs, 2014 ELTE IK
 *
 */
public class AddDropResourceHandler extends AbstractHandler {

	@Override
	public Object execute(ExecutionEvent event) throws ExecutionException {
		String param = event.getParameter("com.refactorerl.ui.addDropResource.mode"); //$NON-NLS-1$

		IServiceLocator serviceLocator = HandlerUtil.getActiveWorkbenchWindow(event).getWorkbench();
		ICommandService commandService = (ICommandService) serviceLocator.getService(ICommandService.class);
		IHandlerService handlerService = (IHandlerService) serviceLocator.getService(IHandlerService.class);

		// NOTE param is "drop" or "add"
		String commandId = param.equals("drop") ? "com.refactorerl.ui.dropFile" //$NON-NLS-1$ //$NON-NLS-2$
				: "com.refactorerl.ui.addFile"; //$NON-NLS-1$
		String parameterId = param.equals("drop") ? "com.refactorerl.ui.dropFile.path" //$NON-NLS-1$ //$NON-NLS-2$
				: "com.refactorerl.ui.addFile.path"; //$NON-NLS-1$

		Command command = commandService.getCommand(commandId);

		IWorkbenchPage activePage = HandlerUtil.getActiveWorkbenchWindow(event).getActivePage();

		IStructuredSelection selection = (IStructuredSelection) activePage.getSelection();

		Iterator it = selection.iterator();

		try {
			while (it.hasNext()) {
				PlatformObject po = (PlatformObject) it.next();
				IFile file = (IFile) po.getAdapter(IFile.class);
				Parameterization p = new Parameterization(command.getParameter(parameterId), file.getLocation()
						.toPortableString());
				ParameterizedCommand pc = new ParameterizedCommand(command, new Parameterization[] { p });

				handlerService.executeCommand(pc, null);
			}
		} catch (NotDefinedException | NotEnabledException | NotHandledException e) {
			Activator.showErrorDialog(e, HandlerUtil.getActiveWorkbenchWindow(event).getShell());
			
		}
		
		// FIXME won't handle views in other perspectives
		// activeWB.getPages() won't work for this either
		final FileListView fileListView = (FileListView) HandlerUtil.getActiveWorkbenchWindow(event).getActivePage().findView(
				"com.refactorerl.ui.fileListView"); //$NON-NLS-1$
		if (fileListView != null)
			fileListView.reload();

		
		return null;
	}

}
