/* 
-*- coding: latin-1 -*-

This file is part of RefactorErl.

RefactorErl is free software: you can redistribute it and/or modify
it under the terms of the GNU Lesser General Public License as published
by the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

RefactorErl is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public License
along with RefactorErl.  If not, see <http://plc.inf.elte.hu/erlang/>.

The Original Code is RefactorErl.

The Initial Developer of the Original Code is Eötvös Loránd University.
Portions created  by Eötvös Loránd University and ELTE-Soft Ltd.
are Copyright 2007-2025 Eötvös Loránd University, ELTE-Soft Ltd.
and Ericsson Hungary. All Rights Reserved.
*/

package com.refactorerl.ui.presentation.event;

import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

import com.refactorerl.ui.communication.event.IEvent;
import com.refactorerl.ui.communication.event.IEventHandler;

public class ReferlEventHandler implements IEventHandler, EventHandler {

	final private IEventHandler eventHandler;

	public ReferlEventHandler(IEventHandler eventHandler) {
		this.eventHandler = eventHandler;
	}

	@Override
	public void handleEvent(IEvent event) {
		eventHandler.handleEvent(event);
	}

	@Override
	public boolean equals(Object obj) {
		if (!(obj instanceof ReferlEventHandler))
			return false;
		else
			return ((ReferlEventHandler) obj).eventHandler.equals(eventHandler);
	}

	@Override
	public void handleEvent(Event event) {
		handleEvent(new ReferlEvent(event));		
	}
}
