/* 
-*- coding: latin-1 -*-

This file is part of RefactorErl.

RefactorErl is free software: you can redistribute it and/or modify
it under the terms of the GNU Lesser General Public License as published
by the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

RefactorErl is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public License
along with RefactorErl.  If not, see <http://plc.inf.elte.hu/erlang/>.

The Original Code is RefactorErl.

The Initial Developer of the Original Code is Eötvös Loránd University.
Portions created  by Eötvös Loránd University and ELTE-Soft Ltd.
are Copyright 2007-2025 Eötvös Loránd University, ELTE-Soft Ltd.
and Ericsson Hungary. All Rights Reserved.
 */

package com.refactorerl.ui.presentation.dupcode;

import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

import com.refactorerl.ui.logic.dupcode.CloneData;
import com.refactorerl.ui.logic.dupcode.GroupData;
import com.refactorerl.ui.presentation.Activator;

public class DupCodeHelper {

	static void openEditor(GroupData group, final Shell shell) {
		try {

			TwinPaneEditor ed = (TwinPaneEditor) PlatformUI
					.getWorkbench()
					.getActiveWorkbenchWindow()
					.getActivePage()
					.openEditor(new TwinPaneEditorInput(group),
							"com.refactorerl.ui.twinPaneEditor"); //$NON-NLS-1$

		} catch (PartInitException e) {

			Activator.showErrorDialog(e, shell);
		}
	}

	public static void closeCloneEditor(GroupData group) {
		IWorkbenchWindow wb = PlatformUI.getWorkbench()
				.getActiveWorkbenchWindow();

		IEditorReference[] openedEditors = wb.getActivePage()
				.getEditorReferences();
		for (IEditorReference er : openedEditors) {
			try {
				IEditorInput input = er.getEditorInput();
				if (input != null && input instanceof TwinPaneEditorInput) {
					TwinPaneEditorInput tpeInput = (TwinPaneEditorInput) input;
					if (tpeInput.groupData.getParentName() == group
							.getParentName()
							&& tpeInput.groupData.getGroupId() == group
									.getGroupId()) {
						IEditorPart ed = er.getEditor(false);
						ed.getEditorSite().getPage().closeEditor(ed, false);

					}
				}
			} catch (PartInitException e) {
				e.printStackTrace();
			}
		}

	}

	public static void closeCloneResultsView() {
		IWorkbenchPage page = PlatformUI.getWorkbench()
				.getActiveWorkbenchWindow().getActivePage();
		IViewReference[] viewReferences = page.getViewReferences();
		for (IViewReference ivr : viewReferences) {
			if (ivr.getId().equalsIgnoreCase(
					"com.refactorerl.ui.cloneResultsView")) {
				page.hideView(ivr);
			}
		}
	}

	/** Closes all editors opened on the supplied CloneData*/
	public static void closeCloneEditors(CloneData cd) {
		for (GroupData gd : cd.getDuplicates()) {
			closeCloneEditor(gd);
		}
	}

	/** Closes all editors opened on any kind of CloneData*/
	public static void closeCloneEditors() {
		IWorkbenchWindow wb = PlatformUI.getWorkbench()
				.getActiveWorkbenchWindow();

		IEditorReference[] openedEditors = wb.getActivePage()
				.getEditorReferences();
		for (IEditorReference er : openedEditors) {
			try {
				IEditorInput input = er.getEditorInput();
				if (input != null && input instanceof TwinPaneEditorInput) {
					IEditorPart ed = er.getEditor(false);
					ed.getEditorSite().getPage().closeEditor(ed, false);
				}
			} catch (PartInitException e) {
				e.printStackTrace();
			}
		}
	}

}
