/* 
-*- coding: latin-1 -*-

This file is part of RefactorErl.

RefactorErl is free software: you can redistribute it and/or modify
it under the terms of the GNU Lesser General Public License as published
by the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

RefactorErl is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public License
along with RefactorErl.  If not, see <http://plc.inf.elte.hu/erlang/>.

The Original Code is RefactorErl.

The Initial Developer of the Original Code is Eötvös Loránd University.
Portions created  by Eötvös Loránd University and ELTE-Soft Ltd.
are Copyright 2007-2025 Eötvös Loránd University, ELTE-Soft Ltd.
and Ericsson Hungary. All Rights Reserved.
*/

package com.refactorerl.ui.presentation.dependency;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.part.ViewPart;

public class ImageView extends ViewPart {
	private Composite composite;


	@Override
	public void createPartControl(Composite parent) {

		ScrolledComposite scroll = new ScrolledComposite(parent, SWT.H_SCROLL | SWT.V_SCROLL);
		
		scroll.setSize(parent.getSize());
		 composite = new Composite(scroll, SWT.NONE);
		scroll.setContent(composite);
		composite.setLayout(new RowLayout());
		composite.pack();
		composite.layout();
	}

	
	public void setImage(String filePath) {
		for(Control c : composite.getChildren())
			c.dispose();
		try{
			Image image = new Image(Display.getDefault(), filePath);
			Label imageHolder = new Label(composite, SWT.NONE);		
			imageHolder.setImage(image);
	
			composite.pack();
			composite.layout();
		} catch (SWTException e){
			MessageDialog.openError(composite.getShell(), Messages.ImageView_0, 
					e.toString() + "\n" + Messages.ImageView_1 + filePath); //$NON-NLS-1$
		}
	}

	@Override
	public void setFocus() {
		

	}

}
