/* 
-*- coding: latin-1 -*-

This file is part of RefactorErl.

RefactorErl is free software: you can redistribute it and/or modify
it under the terms of the GNU Lesser General Public License as published
by the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

RefactorErl is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public License
along with RefactorErl.  If not, see <http://plc.inf.elte.hu/erlang/>.

The Original Code is RefactorErl.

The Initial Developer of the Original Code is Eötvös Loránd University.
Portions created  by Eötvös Loránd University and ELTE-Soft Ltd.
are Copyright 2007-2025 Eötvös Loránd University, ELTE-Soft Ltd.
and Ericsson Hungary. All Rights Reserved.
*/

package com.refactorerl.ui.presentation.codebrowser;

import java.io.ByteArrayInputStream;
import java.io.InputStream;

import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

/**
 * A simple IStorage implementation which "stores" a string as its content and
 * an arbitrary path string. It can be used to represent remote files with its path and content.
 * It can be passed to an IStorageEditorInput to show the content in an editor. 
 * 
 * @author Daniel Lukacs, 2014 ELTE IK
 *
 */
public class StringContentStorage implements IStorage {

	private IPath fullPath = new Path(""); //$NON-NLS-1$

	private String content;

	public StringContentStorage(String path, String content) {
		setPath(path);
		this.content = content;
	}

	public void setPath(String path) {
		fullPath = new Path(path);
	}

	public InputStream getContents() throws CoreException {

		return new ByteArrayInputStream(content.getBytes());

	}

	public String getContentString() {
		return content;
	}

	public IPath getFullPath() {
		return fullPath;
	}

	public Object getAdapter(Class adapter) {
		return null;
	}

	public String getName() {

		return fullPath.lastSegment();
	}

	public boolean isReadOnly() {
		return true;
	}

	@Override
	public boolean equals(Object obj) {
		if (!(obj instanceof StringContentStorage))
			return false;
		StringContentStorage other = (StringContentStorage) obj;
		return getFullPath().equals(other.getFullPath()) && getContentString().equals(other.getContentString());
	}
}