/* 
-*- coding: latin-1 -*-

This file is part of RefactorErl.

RefactorErl is free software: you can redistribute it and/or modify
it under the terms of the GNU Lesser General Public License as published
by the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

RefactorErl is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public License
along with RefactorErl.  If not, see <http://plc.inf.elte.hu/erlang/>.

The Original Code is RefactorErl.

The Initial Developer of the Original Code is Eötvös Loránd University.
Portions created  by Eötvös Loránd University and ELTE-Soft Ltd.
are Copyright 2007-2025 Eötvös Loránd University, ELTE-Soft Ltd.
and Ericsson Hungary. All Rights Reserved.
*/

package com.refactorerl.ui.presentation;

import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;

import com.refactorerl.ui.logic.IsFilePresentRequest;
import com.refactorerl.ui.presentation.codebrowser.RemoteTemporaryFileEditorInput;
import com.refactorerl.ui.presentation.codebrowser.StringInput;

/**
 * Tests if the currently active editor has an input which is added to the RefactorErl database.
 * This is important so the callers are able to decide if they should display RefactorErl-specific
 * actions in the menus and toolbars of the editor.  
 * 
 * @author Daniel Lukacs, 2014 ELTE IK
 *
 */
public class EditorContentInDatabasePropertyTester extends PropertyTester {

	// NOTE this depends on ShowFileHandler implementation
	/**
	 * Executes the test. Non of the arguments are used. 
	 */
	@Override
	public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {

		IEditorInput in = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor()
				.getEditorInput();
		if (in instanceof FileEditorInput) {

			final Boolean inDb = Activator.executeRequest(new IsFilePresentRequest(((FileEditorInput) in).getFile()
					.getLocation().toPortableString(), Activator.getProxy(), null), PlatformUI.getWorkbench()
					.getActiveWorkbenchWindow().getShell(), true);
			if (inDb == null)
				return false;
			return inDb;

		} else {
			// assumes these are only opened for resources in the database
			boolean b = in instanceof RemoteTemporaryFileEditorInput || in instanceof StringInput;
			return b;
		}

	}

}
