/* 
-*- coding: latin-1 -*-

This file is part of RefactorErl.

RefactorErl is free software: you can redistribute it and/or modify
it under the terms of the GNU Lesser General Public License as published
by the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

RefactorErl is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public License
along with RefactorErl.  If not, see <http://plc.inf.elte.hu/erlang/>.

The Original Code is RefactorErl.

The Initial Developer of the Original Code is Eötvös Loránd University.
Portions created  by Eötvös Loránd University and ELTE-Soft Ltd.
are Copyright 2007-2025 Eötvös Loránd University, ELTE-Soft Ltd.
and Ericsson Hungary. All Rights Reserved.
*/

package com.refactorerl.ui.logic.refactoring;

import java.util.Map;
import java.util.logging.Logger;

import com.ericsson.otp.erlang.OtpErlangAtom;
import com.ericsson.otp.erlang.OtpErlangList;
import com.ericsson.otp.erlang.OtpErlangObject;
import com.ericsson.otp.erlang.OtpErlangTuple;
import com.refactorerl.ui.common.OtpErlangHelper;
import com.refactorerl.ui.communication.MessageParseHelper;
import com.refactorerl.ui.communication.ReferlProxy;
import com.refactorerl.ui.communication.exceptions.AbortRequestException;
import com.refactorerl.ui.communication.exceptions.RequestException;
import com.refactorerl.ui.logic.AbstractRequest;

/**
 * The constructor of this class is protected. Use RefactoringRequestFactory to create instances of RefactoringRequest. 
 * @author Daniel Lukacs, 2014 ELTE IK
 *
 */
public class RefactoringRequest extends AbstractRequest<Object> {

	private OtpErlangTuple request;

	protected RefactoringRequest(ReferlProxy proxy, Logger logger, String refactoringName, OtpErlangList propList) {
		super(proxy, logger);
		request = new OtpErlangTuple(new OtpErlangObject[] { new OtpErlangAtom("transform"), //$NON-NLS-1$
				new OtpErlangAtom(refactoringName), propList });
	}
	
	@Override
	public boolean isModifier() {
		return true;
	}

	@Override
	protected OtpErlangObject doGetRequest() {
		return request;
	}

	@Override
	protected Object doProcessReply(OtpErlangObject m) throws RequestException {

		OtpErlangObject body = MessageParseHelper.getBody(m); // {ok, {...}}
		OtpErlangObject inner = OtpErlangHelper.nth(body, 1); // {abort, {Error,
																// Message} |
																// {any(), ...}}
		if (OtpErlangHelper.nthEqualsAtom(inner, 0, "abort")) { //$NON-NLS-1$
			OtpErlangObject errorMessage = OtpErlangHelper.nth(OtpErlangHelper.nth(inner, 1), 1);
			throw new AbortRequestException(OtpErlangHelper.toUnquotedString(errorMessage));
		}

		if (OtpErlangHelper.nthEqualsAtom(inner, 0, "result")) {
			Map<String, OtpErlangObject> props = OtpErlangHelper.translatePropList(OtpErlangHelper.nth(inner, 1));
			if(props.containsKey("error")){
				String errorMessage = OtpErlangHelper.toUnquotedString(props.get("error"));
				throw new AbortRequestException(errorMessage);
			}
		}
		
		return new Object();
	}

}
