/* 
-*- coding: latin-1 -*-

This file is part of RefactorErl.

RefactorErl is free software: you can redistribute it and/or modify
it under the terms of the GNU Lesser General Public License as published
by the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

RefactorErl is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public License
along with RefactorErl.  If not, see <http://plc.inf.elte.hu/erlang/>.

The Original Code is RefactorErl.

The Initial Developer of the Original Code is Eötvös Loránd University.
Portions created  by Eötvös Loránd University and ELTE-Soft Ltd.
are Copyright 2007-2025 Eötvös Loránd University, ELTE-Soft Ltd.
and Ericsson Hungary. All Rights Reserved.
*/

package com.refactorerl.ui.logic.queries;

 public class QueryResultElement {
	private String fileAbsolutePath;
	private int startPos;
	private int endPos;
	private String value;
	private int type;
	private String key;
	
	public static final int NOPOS = 0;
	public static final int VALID_ELEMENT = 1;
	public static final int ERROR = -1;
	public static final int EQ = 3;

	public QueryResultElement(String fileAbsPath, int start, int end,
			String val) {
		fileAbsolutePath = fileAbsPath;
		startPos = start;
		endPos = end;
		value = val;

		type = VALID_ELEMENT;
	}
	
	@Override
	public String toString() {
		return fileAbsolutePath +"|"+ startPos +"|"+ endPos +"|"+ key+"|"+ value; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
	}

	public QueryResultElement(String val) {
		value = val;
		type = NOPOS;
	}
	
	public QueryResultElement(String key, String val) {
		this.key = key;
		value = val;
		type = EQ;
	}

	public QueryResultElement(String val, int error) {
		System.out.println(Messages.QueryResultElement_4 + val + " - " //$NON-NLS-2$
				+ error);
		value = val;
		type = ERROR;
	}

	public int getType() {
		return this.type;
	}

	public String getValue() {
		return value;
	}

	public int getStartPosition() {
		return this.startPos;
	}

	public int getEndPosition() {
		return this.endPos;
	}

	public String getFileAbsolutePath() {
		return fileAbsolutePath;
	}
}
