/* 
-*- coding: latin-1 -*-

This file is part of RefactorErl.

RefactorErl is free software: you can redistribute it and/or modify
it under the terms of the GNU Lesser General Public License as published
by the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

RefactorErl is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public License
along with RefactorErl.  If not, see <http://plc.inf.elte.hu/erlang/>.

The Original Code is RefactorErl.

The Initial Developer of the Original Code is Eötvös Loránd University.
Portions created  by Eötvös Loránd University and ELTE-Soft Ltd.
are Copyright 2007-2025 Eötvös Loránd University, ELTE-Soft Ltd.
and Ericsson Hungary. All Rights Reserved.
*/

package com.refactorerl.ui.logic.queries;

import java.util.ArrayList;
import java.util.List;
import java.util.SortedMap;
import java.util.logging.Logger;

import com.ericsson.otp.erlang.OtpErlangAtom;
import com.ericsson.otp.erlang.OtpErlangList;
import com.ericsson.otp.erlang.OtpErlangObject;
import com.ericsson.otp.erlang.OtpErlangTuple;
import com.refactorerl.ui.common.OtpErlangHelper;
import com.refactorerl.ui.communication.MessageParseHelper;
import com.refactorerl.ui.communication.ReferlProxy;
import com.refactorerl.ui.communication.exceptions.RequestException;
import com.refactorerl.ui.logic.AbstractRequest;

public class QueryHistoryRequest extends
		AbstractRequest<List<QueryHistoryElement>> {

	private OtpErlangTuple request;

	public QueryHistoryRequest(ReferlProxy proxy, Logger logger) {
		super(proxy, logger);
		
		// {find_in_qtab_by_pattern,{'_','_','_','_','_','_'} 
		request = new OtpErlangTuple(new OtpErlangObject[] {
				new OtpErlangAtom("find_in_qtab_by_pattern"), //$NON-NLS-1$
				OtpErlangHelper.createTuple(new OtpErlangAtom("_"), //$NON-NLS-1$
						new OtpErlangAtom("_"), new OtpErlangAtom("_"), //$NON-NLS-1$ //$NON-NLS-2$
						new OtpErlangAtom("_"), new OtpErlangAtom("_"), //$NON-NLS-1$ //$NON-NLS-2$
						new OtpErlangAtom("_")) }); //$NON-NLS-1$
	}

	@Override
	protected OtpErlangObject doGetRequest() {
		return request;
	}

	@Override
	protected List<QueryHistoryElement> doProcessReply(OtpErlangObject m) throws RequestException {

		List<QueryHistoryElement> history = new ArrayList<>();
		
		OtpErlangList ls = (OtpErlangList) OtpErlangHelper.nth(MessageParseHelper.getBody(m), 1);
			
		for(OtpErlangObject o : ls.elements()){
			
			OtpErlangTuple historyId = (OtpErlangTuple) OtpErlangHelper.nth(o, 1);
	
			String queryString = OtpErlangHelper.nth(historyId, 0).toString().replaceAll("^\"|\"$", ""); //$NON-NLS-1$ //$NON-NLS-2$
			
			String fileName = null;
			Integer startPos = null;
			
			if(!OtpErlangHelper.nthEqualsAtom(historyId, 1, "no_file")) //$NON-NLS-1$
				fileName = OtpErlangHelper.nth(historyId, 1).toString().replaceAll("^\"|\"$", ""); //$NON-NLS-1$ //$NON-NLS-2$
			
			if(!OtpErlangHelper.nthEqualsAtom(historyId, 2, "no_pos")) //$NON-NLS-1$
				startPos =Integer.parseInt(OtpErlangHelper.nth(historyId, 2).toString());
			
			OtpErlangList queryResults0 = (OtpErlangList) OtpErlangHelper.nth(o, 4);		
			SortedMap<String, List<QueryResultElement>> queryResults = QueryRequest.processQueryResult(queryResults0);
			
			history.add(new QueryHistoryElement(queryString, fileName, startPos, queryResults));
			
		}
	
		return history;
	}

}
