/* 
-*- coding: latin-1 -*-

This file is part of RefactorErl.

RefactorErl is free software: you can redistribute it and/or modify
it under the terms of the GNU Lesser General Public License as published
by the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

RefactorErl is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public License
along with RefactorErl.  If not, see <http://plc.inf.elte.hu/erlang/>.

The Original Code is RefactorErl.

The Initial Developer of the Original Code is Eötvös Loránd University.
Portions created  by Eötvös Loránd University and ELTE-Soft Ltd.
are Copyright 2007-2025 Eötvös Loránd University, ELTE-Soft Ltd.
and Ericsson Hungary. All Rights Reserved.
*/

package com.refactorerl.ui.logic.queries;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

import com.ericsson.otp.erlang.OtpErlangList;
import com.ericsson.otp.erlang.OtpErlangObject;
import com.ericsson.otp.erlang.OtpErlangString;
import com.refactorerl.ui.common.OtpErlangHelper;
import com.refactorerl.ui.common.Pair;
import com.refactorerl.ui.communication.ReferlProxy;
import com.refactorerl.ui.communication.exceptions.CommunicationException;
import com.refactorerl.ui.communication.exceptions.ConnectionException;
import com.refactorerl.ui.communication.exceptions.RequestException;
import com.refactorerl.ui.logic.AbstractRequest;

public class QueryAutoCompleteRequest extends AbstractRequest<List<Pair<String,String>>> {

	String prefix;

	public QueryAutoCompleteRequest(String prefix, ReferlProxy proxy,
			Logger logger) {
		super(proxy, logger);
		this.prefix = prefix;
	}

	@Override
	public List<Pair<String,String>> execute() throws RequestException, ConnectionException, CommunicationException {

		String module = "refusr_ac"; //$NON-NLS-1$
		String function = "run"; //$NON-NLS-1$

		return doProcessReply(proxy.sendRPC(module, function,
				new OtpErlangString(prefix)));

	}

	@Override
	protected OtpErlangObject doGetRequest() {
		return null;
	}

	@Override
	protected List<Pair<String,String>> doProcessReply(OtpErlangObject m0)
			throws RequestException {
		List<Pair<String,String>> props = new ArrayList<>();
		try {
			OtpErlangList m = (OtpErlangList) m0;
			for (OtpErlangObject t0 : m.elements()) {
				OtpErlangObject pref0 = OtpErlangHelper.nth(t0, 0);
				OtpErlangObject suff0 = OtpErlangHelper.nth(t0, 1);
				String pref = pref0.toString().equals("[]") ? "": ((OtpErlangString) pref0).stringValue(); //$NON-NLS-1$ //$NON-NLS-2$
				String suff = suff0.toString().equals("[]") ? "": ((OtpErlangString) suff0).stringValue(); //$NON-NLS-1$ //$NON-NLS-2$
				
				props.add(new Pair<String, String>(pref,suff));
			}
			
			
		} catch (ClassCastException | IllegalArgumentException e) {
			throw new RequestException(e.getMessage());
		}

		return props;
	}

}
