/* 
-*- coding: latin-1 -*-

This file is part of RefactorErl.

RefactorErl is free software: you can redistribute it and/or modify
it under the terms of the GNU Lesser General Public License as published
by the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

RefactorErl is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public License
along with RefactorErl.  If not, see <http://plc.inf.elte.hu/erlang/>.

The Original Code is RefactorErl.

The Initial Developer of the Original Code is Eötvös Loránd University.
Portions created  by Eötvös Loránd University and ELTE-Soft Ltd.
are Copyright 2007-2025 Eötvös Loránd University, ELTE-Soft Ltd.
and Ericsson Hungary. All Rights Reserved.
*/

package com.refactorerl.ui.logic.queries;

import java.util.ArrayList;
import java.util.List;
import java.util.SortedMap;
import java.util.logging.Logger;

import com.ericsson.otp.erlang.OtpErlangObject;
import com.refactorerl.ui.communication.ReferlProxy;
import com.refactorerl.ui.communication.exceptions.CommunicationException;
import com.refactorerl.ui.communication.exceptions.ConnectionException;
import com.refactorerl.ui.communication.exceptions.RequestException;
import com.refactorerl.ui.logic.AbstractRequest;

public class ListQueryRequest extends AbstractRequest<List<String>> {

	public static ListQueryRequest createModuleListQueryRequest(ReferlProxy proxy, Logger logger) {
		return new ListQueryRequest("mods", proxy, logger); //$NON-NLS-1$
	}

	public static ListQueryRequest createFunctionListQueryRequest(ReferlProxy proxy, Logger logger) {
		return new ListQueryRequest("mods.funs", proxy, logger); //$NON-NLS-1$
	}

	public static ListQueryRequest createDirectoryListQueryRequest(ReferlProxy proxy, Logger logger) {
		return new ListQueryRequest("files.directory", proxy, logger); //$NON-NLS-1$
	}

	private String query;

	public ListQueryRequest(String query, ReferlProxy proxy, Logger logger) {
		super(proxy, logger);
		this.query = query;
	}

	@Override
	public List<String> execute() throws RequestException, ConnectionException, CommunicationException {
		SortedMap<String, List<QueryResultElement>> queryResults = new QueryRequest(query, false, proxy, logger)
				.execute();

		List<String> results = new ArrayList<>();
		if (queryResults != null && !queryResults.isEmpty())
			for (String key : queryResults.keySet()) {
				for (QueryResultElement el : queryResults.get(key)) {
					results.add(el.getValue().replaceAll("^\"|\"$", "")); //$NON-NLS-1$ //$NON-NLS-2$
				}
			}
		
		return results;
	}

	@Override
	protected OtpErlangObject doGetRequest() {
		return null;
	}

	@Override
	protected List<String> doProcessReply(OtpErlangObject m) throws RequestException {
		return null;
	}

}
