/* 
-*- coding: latin-1 -*-

This file is part of RefactorErl.

RefactorErl is free software: you can redistribute it and/or modify
it under the terms of the GNU Lesser General Public License as published
by the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

RefactorErl is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public License
along with RefactorErl.  If not, see <http://plc.inf.elte.hu/erlang/>.

The Original Code is RefactorErl.

The Initial Developer of the Original Code is Eötvös Loránd University.
Portions created  by Eötvös Loránd University and ELTE-Soft Ltd.
are Copyright 2007-2025 Eötvös Loránd University, ELTE-Soft Ltd.
and Ericsson Hungary. All Rights Reserved.
*/

package com.refactorerl.ui.logic.investigations;

import java.util.logging.Logger;

import com.ericsson.otp.erlang.OtpErlangAtom;
import com.ericsson.otp.erlang.OtpErlangObject;
import com.ericsson.otp.erlang.OtpErlangTuple;
import com.refactorerl.ui.common.OtpErlangHelper;
import com.refactorerl.ui.communication.MessageParseHelper;
import com.refactorerl.ui.communication.ReferlProxy;
import com.refactorerl.ui.logic.AbstractRequest;

public class NodeBasedRequest extends AbstractRequest<OtpErlangObject> {

	private OtpErlangTuple request;

	protected static NodeBasedRequest createNodePositionRequest(
			OtpErlangObject node, ReferlProxy proxy, Logger logger) {
		return new NodeBasedRequest("node_pos", node, proxy, logger); //$NON-NLS-1$

	}

	protected static NodeBasedRequest createStartPositionRequest(
			OtpErlangObject node, ReferlProxy proxy, Logger logger) {
		return new NodeBasedRequest("start_pos", node, proxy, logger); //$NON-NLS-1$

	}

	protected static NodeBasedRequest createSynLeavesRequest(
			OtpErlangObject node, ReferlProxy proxy, Logger logger) {
		return new NodeBasedRequest("syn_leaves", node, proxy, logger); //$NON-NLS-1$

	}
	
	protected static NodeBasedRequest createFunctionTextRequest(
			OtpErlangObject functionNode, ReferlProxy proxy, Logger logger) {
		return new NodeBasedRequest("function_text", functionNode, proxy, logger); //$NON-NLS-1$

	}


	private NodeBasedRequest(String function, OtpErlangObject node,
			ReferlProxy proxy, Logger logger) {
		super(proxy, logger);
		request = OtpErlangHelper.createTuple(new OtpErlangAtom(function), node);
	}

	@Override
	protected OtpErlangObject doGetRequest() {
		return request;
	}

	@Override
	protected OtpErlangObject doProcessReply(OtpErlangObject m) {
		OtpErlangObject msg = OtpErlangHelper.nth(
				MessageParseHelper.getBody(m), 1);
		return msg;
	}
}
