/* 
-*- coding: latin-1 -*-

This file is part of RefactorErl.

RefactorErl is free software: you can redistribute it and/or modify
it under the terms of the GNU Lesser General Public License as published
by the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

RefactorErl is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public License
along with RefactorErl.  If not, see <http://plc.inf.elte.hu/erlang/>.

The Original Code is RefactorErl.

The Initial Developer of the Original Code is Eötvös Loránd University.
Portions created  by Eötvös Loránd University and ELTE-Soft Ltd.
are Copyright 2007-2025 Eötvös Loránd University, ELTE-Soft Ltd.
and Ericsson Hungary. All Rights Reserved.
*/

package com.refactorerl.ui.logic.filelist;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

import com.ericsson.otp.erlang.OtpErlangAtom;
import com.ericsson.otp.erlang.OtpErlangList;
import com.ericsson.otp.erlang.OtpErlangObject;
import com.ericsson.otp.erlang.OtpErlangTuple;
import com.refactorerl.ui.common.OtpErlangHelper;
import com.refactorerl.ui.common.Pair;
import com.refactorerl.ui.communication.MessageParseHelper;
import com.refactorerl.ui.communication.ReferlProxy;
import com.refactorerl.ui.logic.AbstractRequest;

public class GetEnvsRequest extends AbstractRequest<List<Pair<String, String>>> {

	private OtpErlangTuple request;

	public GetEnvsRequest(ReferlProxy proxy, Logger logger) {
		super(proxy, logger);
		request = new OtpErlangTuple(new OtpErlangObject[] { new OtpErlangAtom("get_envs") }); //$NON-NLS-1$
	}

	@Override
	protected OtpErlangObject doGetRequest() {

		return request;

	}

	@Override
	protected List<Pair<String, String>> doProcessReply(OtpErlangObject m) {
		List<Pair<String, String>> envs = new ArrayList<>(); 
																
		OtpErlangObject body = MessageParseHelper.getBody(m);
		OtpErlangList ls = (OtpErlangList) OtpErlangHelper.nth(body, 1);
		for (OtpErlangObject o : ls.elements()) {
			String key = OtpErlangHelper.toUnquotedString(OtpErlangHelper.nth(o, 0));

			if (!(key.equals("appbase") || key.equals("include"))) //$NON-NLS-1$ //$NON-NLS-2$
				continue; 

			OtpErlangList vals = OtpErlangHelper.nth(o, 1);
			for (OtpErlangObject val : vals.elements()) {
				envs.add(new Pair<String, String>(key, val.toString().replaceAll("^\\[|\\]$", "").replaceAll("^\"|\"$", ""))); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
			}

			//
			// String value = OtpErlangHelper.getNth(o,
			// 1).toString().replaceAll("^\\[|\\]$", "")
			// .replaceAll("^\"|\"$", "");

		}

		return envs;

	}

}
