/* 
-*- coding: latin-1 -*-

This file is part of RefactorErl.

RefactorErl is free software: you can redistribute it and/or modify
it under the terms of the GNU Lesser General Public License as published
by the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

RefactorErl is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public License
along with RefactorErl.  If not, see <http://plc.inf.elte.hu/erlang/>.

The Original Code is RefactorErl.

The Initial Developer of the Original Code is Eötvös Loránd University.
Portions created  by Eötvös Loránd University and ELTE-Soft Ltd.
are Copyright 2007-2025 Eötvös Loránd University, ELTE-Soft Ltd.
and Ericsson Hungary. All Rights Reserved.
*/

package com.refactorerl.ui.logic.filelist;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

import com.ericsson.otp.erlang.OtpErlangAtom;
import com.ericsson.otp.erlang.OtpErlangList;
import com.ericsson.otp.erlang.OtpErlangObject;
import com.ericsson.otp.erlang.OtpErlangString;
import com.refactorerl.ui.common.OtpErlangHelper;
import com.refactorerl.ui.communication.ReferlProxy;
import com.refactorerl.ui.communication.exceptions.CommunicationException;
import com.refactorerl.ui.communication.exceptions.ConnectionException;
import com.refactorerl.ui.communication.exceptions.RequestException;
import com.refactorerl.ui.logic.AbstractRequest;
import com.refactorerl.ui.logic.GraphQueryRequest;

public class FileListRequest extends AbstractRequest<List<String>> {

	private ReferlProxy proxy;
	private Logger logger;

	public FileListRequest(ReferlProxy proxy, Logger logger) {
		super(proxy, logger);
		this.proxy = proxy;
		this.logger = logger;
	}

	public List<String> execute() throws RequestException, ConnectionException, CommunicationException {
		OtpErlangList ls = (OtpErlangList) new GraphQueryRequest("reflib_query", "exec", //$NON-NLS-1$ //$NON-NLS-2$
				OtpErlangHelper.createList(OtpErlangHelper.createList(new OtpErlangAtom("file"))), proxy, logger) //$NON-NLS-1$
				.execute();
		
		List<String> files = new ArrayList<>();
		for (OtpErlangObject o : ls) {
			OtpErlangString otpStr = (OtpErlangString) new GraphQueryRequest("reflib_file", "path", //$NON-NLS-1$ //$NON-NLS-2$
					OtpErlangHelper.createList(o), proxy, logger)
					.execute();
			files.add(OtpErlangHelper.toUnquotedString(otpStr));			
		}
		
		return files;
	};

	@Override
	protected OtpErlangObject doGetRequest() {

		return null;
	}

	@Override
	protected List<String> doProcessReply(OtpErlangObject msg) {
		return null;

	}

}
