/* 
-*- coding: latin-1 -*-

This file is part of RefactorErl.

RefactorErl is free software: you can redistribute it and/or modify
it under the terms of the GNU Lesser General Public License as published
by the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

RefactorErl is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public License
along with RefactorErl.  If not, see <http://plc.inf.elte.hu/erlang/>.

The Original Code is RefactorErl.

The Initial Developer of the Original Code is Eötvös Loránd University.
Portions created  by Eötvös Loránd University and ELTE-Soft Ltd.
are Copyright 2007-2025 Eötvös Loránd University, ELTE-Soft Ltd.
and Ericsson Hungary. All Rights Reserved.
*/

package com.refactorerl.ui.logic.dupcode;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import com.refactorerl.ui.common.FilePosition;

public class GroupData {
	private int groupId;
	private List<FilePosition> members;
	private String parentName;
	public GroupData(int groupId, FilePosition[] members, String parentName) {
		this.groupId = groupId;
		this.members =Arrays.asList(members);
		this.parentName = parentName;
	}
	
	public int getGroupId(){
		return groupId;
	}
	
	/**
	 * @return An unmodifiable collection containing the members of this group.
	 */
	public List<FilePosition> getMembers(){
		return  Collections.unmodifiableList(members);		
	}
	
	public String getParentName(){
		return parentName;
	}
	

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + groupId;
		result = prime * result + ((members == null) ? 0 : members.hashCode());
		result = prime * result
				+ ((parentName == null) ? 0 : parentName.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		GroupData other = (GroupData) obj;
		if (groupId != other.groupId)
			return false;
		if (members == null) {
			if (other.members != null)
				return false;
		} else if (!members.equals(other.members))
			return false;
		if (parentName == null) {
			if (other.parentName != null)
				return false;
		} else if (!parentName.equals(other.parentName))
			return false;
		return true;
	}

	
	
	
}
