/* 
-*- coding: latin-1 -*-

This file is part of RefactorErl.

RefactorErl is free software: you can redistribute it and/or modify
it under the terms of the GNU Lesser General Public License as published
by the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

RefactorErl is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public License
along with RefactorErl.  If not, see <http://plc.inf.elte.hu/erlang/>.

The Original Code is RefactorErl.

The Initial Developer of the Original Code is Eötvös Loránd University.
Portions created  by Eötvös Loránd University and ELTE-Soft Ltd.
are Copyright 2007-2025 Eötvös Loránd University, ELTE-Soft Ltd.
and Ericsson Hungary. All Rights Reserved.
*/

package com.refactorerl.ui.logic.dependency;

import java.util.List;
import java.util.logging.Logger;

import com.ericsson.otp.erlang.OtpErlangAtom;
import com.ericsson.otp.erlang.OtpErlangList;
import com.ericsson.otp.erlang.OtpErlangObject;
import com.ericsson.otp.erlang.OtpErlangTuple;
import com.refactorerl.ui.common.OtpErlangHelper;
import com.refactorerl.ui.communication.MessageParseHelper;
import com.refactorerl.ui.communication.ReferlProxy;
import com.refactorerl.ui.communication.exceptions.RequestException;
import com.refactorerl.ui.logic.AbstractRequest;

public class PrintDependencyRequest extends DependencyRequest/*AbstractRequest<String>*/ {

	protected PrintDependencyRequest(String depRequestName, OtpErlangList propList, ReferlProxy proxy, Logger logger) {
		super(depRequestName, propList, proxy, logger);
	}

//	private OtpErlangTuple request;

//	public PrintDependencyRequest(String depRequestName,
//			List<String> modFunList, ReferlProxy proxy, Logger logger) {
//		super(proxy, logger);
//
//		if (modFunList.isEmpty()) {
//			request = new OtpErlangTuple(
//					new OtpErlangObject[] { new OtpErlangAtom(depRequestName) });
//		} else {
//
//			OtpErlangObject[] otpModsOrFuns = new OtpErlangObject[modFunList
//					.size()];
//			for (int i = 0; i < modFunList.size(); i++) {
//				otpModsOrFuns[i] = new OtpErlangAtom(modFunList.get(i));
//			}
//			OtpErlangHelper.createList(otpModsOrFuns);
//
//			request = new OtpErlangTuple(new OtpErlangObject[] {
//					new OtpErlangAtom(depRequestName),
//					OtpErlangHelper.createList(otpModsOrFuns) });
//		}
//
//	}

//	@Override
//	protected OtpErlangObject doGetRequest() {
//		return request;
//	}

	@Override
	protected String doProcessReply(OtpErlangObject m) throws RequestException {

		if (!MessageParseHelper.isBodyOK(m)) {
			return null;
		}

		StringBuilder sb = new StringBuilder();

		OtpErlangList list = (OtpErlangList) OtpErlangHelper.nth(
				MessageParseHelper.getBody(m), 1);
		for (OtpErlangObject o : list) {

			sb.append(OtpErlangHelper.nth(o, 0).toString());
			sb.append(" -> "); //$NON-NLS-1$
			sb.append(OtpErlangHelper.nth(o, 1).toString());
			sb.append("\n"); //$NON-NLS-1$
		}

		return sb.toString();
	}

}
