/* 
-*- coding: latin-1 -*-

This file is part of RefactorErl.

RefactorErl is free software: you can redistribute it and/or modify
it under the terms of the GNU Lesser General Public License as published
by the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

RefactorErl is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public License
along with RefactorErl.  If not, see <http://plc.inf.elte.hu/erlang/>.

The Original Code is RefactorErl.

The Initial Developer of the Original Code is Eötvös Loránd University.
Portions created  by Eötvös Loránd University and ELTE-Soft Ltd.
are Copyright 2007-2025 Eötvös Loránd University, ELTE-Soft Ltd.
and Ericsson Hungary. All Rights Reserved.
*/

package com.refactorerl.ui.logic;

import java.util.Iterator;
import java.util.Map;
import java.util.logging.Logger;

import com.ericsson.otp.erlang.OtpErlangAtom;
import com.ericsson.otp.erlang.OtpErlangObject;
import com.ericsson.otp.erlang.OtpErlangString;
import com.ericsson.otp.erlang.OtpErlangTuple;
import com.refactorerl.ui.common.OtpErlangHelper;
import com.refactorerl.ui.communication.MessageParseHelper;
import com.refactorerl.ui.communication.ReferlProxy;
import com.refactorerl.ui.communication.exceptions.RequestException;

public class IsFilePresentRequest extends AbstractRequest<Boolean> {

	private OtpErlangTuple request;

	public IsFilePresentRequest(String filepath, ReferlProxy proxy,
			Logger logger) {
		super(proxy, logger);
		request = OtpErlangHelper.createTuple(new OtpErlangAtom("status"), //$NON-NLS-1$
				new OtpErlangString(filepath));
	}

	@Override
	protected OtpErlangObject doGetRequest() {
		
		return request;
	}

	@Override
	protected Boolean doProcessReply(OtpErlangObject m) throws RequestException {
		if (!MessageParseHelper.isBodyOK(m))
			throw new RequestException(Messages.IsFilePresentRequest_1 + m.toString());
		
		OtpErlangObject body = MessageParseHelper.getBody(m);
		Map<String, OtpErlangObject> files = OtpErlangHelper
				.translatePropList(OtpErlangHelper.nth(body, 1));
		String fileName;
		final Iterator<String> it = files.keySet().iterator();
		if (it.hasNext())
			fileName = it.next();
		else
			throw new RequestException(Messages.IsFilePresentRequest_2
					+ m.toString());

		Map<String, OtpErlangObject> props = OtpErlangHelper
				.translatePropList(files.get(fileName));

		Boolean b = OtpErlangHelper.booleanValue(props.get("present")); //$NON-NLS-1$
		if (b == null) {
			throw new RequestException(Messages.IsFilePresentRequest_4 + m.toString());
		}
		return b;
	}

}
