/* 
-*- coding: latin-1 -*-

This file is part of RefactorErl.

RefactorErl is free software: you can redistribute it and/or modify
it under the terms of the GNU Lesser General Public License as published
by the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

RefactorErl is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public License
along with RefactorErl.  If not, see <http://plc.inf.elte.hu/erlang/>.

The Original Code is RefactorErl.

The Initial Developer of the Original Code is Eötvös Loránd University.
Portions created  by Eötvös Loránd University and ELTE-Soft Ltd.
are Copyright 2007-2025 Eötvös Loránd University, ELTE-Soft Ltd.
and Ericsson Hungary. All Rights Reserved.
*/

package com.refactorerl.ui.logic;

import java.util.logging.Logger;

import com.ericsson.otp.erlang.OtpErlangAtom;
import com.ericsson.otp.erlang.OtpErlangList;
import com.ericsson.otp.erlang.OtpErlangObject;
import com.ericsson.otp.erlang.OtpErlangTuple;
import com.refactorerl.ui.common.OtpErlangHelper;
import com.refactorerl.ui.communication.MessageParseHelper;
import com.refactorerl.ui.communication.ReferlProxy;

public class GraphQueryRequest extends AbstractRequest<OtpErlangObject> {

	private OtpErlangTuple request;

	public GraphQueryRequest(String mod, String fun, OtpErlangList args,
			ReferlProxy proxy, Logger logger) {
		super(proxy, logger);
		request = OtpErlangHelper.createTuple(new OtpErlangAtom("graph_query"), //$NON-NLS-1$
				new OtpErlangAtom(mod), new OtpErlangAtom(fun), args);
	}

	@Override
	protected OtpErlangObject doGetRequest() {
		return request;
	}

	@Override
	protected OtpErlangObject doProcessReply(OtpErlangObject m) {
		return OtpErlangHelper.nth(MessageParseHelper.getBody(m), 1);
		
	}
}
