/* 
-*- coding: latin-1 -*-

This file is part of RefactorErl.

RefactorErl is free software: you can redistribute it and/or modify
it under the terms of the GNU Lesser General Public License as published
by the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

RefactorErl is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public License
along with RefactorErl.  If not, see <http://plc.inf.elte.hu/erlang/>.

The Original Code is RefactorErl.

The Initial Developer of the Original Code is Eötvös Loránd University.
Portions created  by Eötvös Loránd University and ELTE-Soft Ltd.
are Copyright 2007-2025 Eötvös Loránd University, ELTE-Soft Ltd.
and Ericsson Hungary. All Rights Reserved.
*/

package com.refactorerl.ui.logic;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

import com.ericsson.otp.erlang.OtpErlangAtom;
import com.ericsson.otp.erlang.OtpErlangList;
import com.ericsson.otp.erlang.OtpErlangObject;
import com.ericsson.otp.erlang.OtpErlangString;
import com.ericsson.otp.erlang.OtpErlangTuple;
import com.refactorerl.ui.common.OtpErlangHelper;
import com.refactorerl.ui.common.Pair;
import com.refactorerl.ui.communication.MessageParseHelper;
import com.refactorerl.ui.communication.ReferlProxy;
import com.refactorerl.ui.communication.exceptions.RequestException;

public class FunctionListRequest extends
		AbstractRequest<List<Pair<String, Integer>>> {

	OtpErlangObject request;

	public FunctionListRequest(String filePath, ReferlProxy proxy, Logger logger) {
		super(proxy, logger);		
		request = new OtpErlangTuple(new OtpErlangObject[] {
				new OtpErlangAtom("funlist"), new OtpErlangString(filePath) }); //$NON-NLS-1$
	}

	@Override
	protected OtpErlangObject doGetRequest() {
		return request;
	}

	@Override
	protected List<Pair<String, Integer>> doProcessReply(OtpErlangObject m)
			throws RequestException {
			List<Pair<String, Integer>> results = new ArrayList<>();
			OtpErlangObject b = MessageParseHelper.getBody(m);
			OtpErlangList ls = (OtpErlangList) OtpErlangHelper.nth(b, 1);
			for (OtpErlangObject o : ls.elements()) {
				String funName = OtpErlangHelper.toUnquotedString(OtpErlangHelper.nth(o, 0));
				Integer funArity = Integer.parseInt(OtpErlangHelper.nth(o, 1).toString());
				results.add(new Pair<String, Integer>(funName, funArity));
			}

			return results;
	}

}
