/* 
-*- coding: latin-1 -*-

This file is part of RefactorErl.

RefactorErl is free software: you can redistribute it and/or modify
it under the terms of the GNU Lesser General Public License as published
by the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

RefactorErl is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public License
along with RefactorErl.  If not, see <http://plc.inf.elte.hu/erlang/>.

The Original Code is RefactorErl.

The Initial Developer of the Original Code is Eötvös Loránd University.
Portions created  by Eötvös Loránd University and ELTE-Soft Ltd.
are Copyright 2007-2025 Eötvös Loránd University, ELTE-Soft Ltd.
and Ericsson Hungary. All Rights Reserved.
*/

package com.refactorerl.ui.communication;

import com.ericsson.otp.erlang.OtpErlangObject;
import com.ericsson.otp.erlang.OtpErlangString;
import com.refactorerl.ui.common.OtpErlangHelper;

/**
 * This class defines the topics to use when handling the messages from RefactorErl
 * in the internal event handling procedure.
 * 
 * @author Daniel Lukacs, 2014 ELTE IK
 *
 */
public class MessageTopicHelper {
	static public String TOPIC_SEPARATOR = "/"; //$NON-NLS-1$
	static public String TOPIC_PREFIX = "refactorerl"; //$NON-NLS-1$

	static public String getReplyTopic(OtpErlangObject reqId) {

		String reqIdString = ((OtpErlangString) OtpErlangHelper.nth(reqId, 1))
				.toString();

		return TOPIC_PREFIX + TOPIC_SEPARATOR + reqIdString.hashCode();

	}

	static public String getStatusInfoTopic() {

		return TOPIC_PREFIX + TOPIC_SEPARATOR + "statusinfo"; //$NON-NLS-1$
	}

	static public String getJobInfoTopic() {
		return TOPIC_PREFIX + TOPIC_SEPARATOR + "jobinfo"; //$NON-NLS-1$
	}

	static public String[] getAllGlobalTopics() {
		return new String[] { getStatusInfoTopic(), getJobInfoTopic() };
	}

	static public String parseTopic(OtpErlangObject msg) {

		OtpErlangObject header = MessageParseHelper.getHeader(msg);

		String infoType = MessageParseHelper.getType(msg);

		OtpErlangObject body = MessageParseHelper.getBody(msg);

		if (OtpErlangHelper.equalsAtom(header, "global")) { //$NON-NLS-1$
			if (infoType.equals("statusinfo")) { //$NON-NLS-1$
				return getStatusInfoTopic();
			} else if (infoType.equals("jobinfo")) { //$NON-NLS-1$
				return getJobInfoTopic();
			} else
				;

		} else if (OtpErlangHelper.nthEqualsAtom(header, 0, "reqid")) { //$NON-NLS-1$
			// OtpErlangObject reqId = OtpErlangHelper.getNth(header, 1);
			return getReplyTopic(header);
		}

		return "hello"; //$NON-NLS-1$
	}

}
