/* 
-*- coding: latin-1 -*-

This file is part of RefactorErl.

RefactorErl is free software: you can redistribute it and/or modify
it under the terms of the GNU Lesser General Public License as published
by the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

RefactorErl is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public License
along with RefactorErl.  If not, see <http://plc.inf.elte.hu/erlang/>.

The Original Code is RefactorErl.

The Initial Developer of the Original Code is Eötvös Loránd University.
Portions created  by Eötvös Loránd University and ELTE-Soft Ltd.
are Copyright 2007-2025 Eötvös Loránd University, ELTE-Soft Ltd.
and Ericsson Hungary. All Rights Reserved.
*/

package com.refactorerl.ui.communication;

import com.ericsson.otp.erlang.OtpErlangObject;

/**
 * Java representation of a job info message sent by RefactorErl.
 * @author Daniel Lukacs, 2014 ELTE IK
 *
 */
public class JobInfoMessage {
	
	public enum Status {STARTED, FINISHED};

	public final OtpErlangObject fullMessage;
	public final String jobName;
	public final boolean modifier;
	public final Status status;
	public final OtpErlangObject content;
	public final String info;
	
	
	public JobInfoMessage(OtpErlangObject fullMessage, String jobName, boolean modifier,
			Status status, OtpErlangObject content, String info) {
		super();
		this.fullMessage = fullMessage;
		this.jobName = jobName;
		this.modifier = modifier;
		this.status = status;
		this.content = content;
		this.info = info;
	}
	
	@Override
	public String toString() {
	
		return "(" + jobName + ", " + modifier + ", " + status + ", " + content.toString() + ", " + info + ")"; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$ //$NON-NLS-6$
	}
	
}
