/* 
-*- coding: latin-1 -*-

This file is part of RefactorErl.

RefactorErl is free software: you can redistribute it and/or modify
it under the terms of the GNU Lesser General Public License as published
by the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

RefactorErl is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public License
along with RefactorErl.  If not, see <http://plc.inf.elte.hu/erlang/>.

The Original Code is RefactorErl.

The Initial Developer of the Original Code is Eötvös Loránd University.
Portions created  by Eötvös Loránd University and ELTE-Soft Ltd.
are Copyright 2007-2025 Eötvös Loránd University, ELTE-Soft Ltd.
and Ericsson Hungary. All Rights Reserved.
*/

package com.refactorerl.ui.common;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class Environment {
	public static final String TMP_DIR_NAME = "refactorerl";
	
	public static boolean isLocalSysWindows(){
		String os = System.getProperty("os.name").toLowerCase(); //$NON-NLS-1$
		return os.indexOf("win") >= 0;
	}
	
	// this directory is deleted when when the plugin stops running, set with caution!
	public static File getTempDir() throws IOException{
		File tmpDir = new File(System.getProperty("java.io.tmpdir") + File.separator + TMP_DIR_NAME);
		tmpDir.mkdir();	
		if(!tmpDir.exists() || !tmpDir.isDirectory()){
			throw new IOException("Could not use temp directory: " + tmpDir.getAbsolutePath());
		}
		return tmpDir;
	}
	
	public static String getHostName() {
		try {
			return InetAddress.getLocalHost().getHostName();
		} catch (UnknownHostException e) {
			System.out.println(e); // todo
			return null;
		}
	}
	
	
}
