%%% This file is part of RefactorErl.
%%%
%%% RefactorErl is free software: you can redistribute it and/or modify
%%% it under the terms of the GNU Lesser General Public License as published
%%% by the Free Software Foundation, either version 3 of the License, or
%%% (at your option) any later version.
%%%
%%% RefactorErl is distributed in the hope that it will be useful,
%%% but WITHOUT ANY WARRANTY; without even the implied warranty of
%%% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%%% GNU Lesser General Public License for more details.
%%%
%%% You should have received a copy of the GNU Lesser General Public License
%%% along with RefactorErl.  If not, see <http://plc.inf.elte.hu/erlang/>.
%%%
%%% The Original Code is RefactorErl.
%%%
%%% The Initial Developer of the Original Code is Eötvös Loránd University.
%%% Portions created  by Eötvös Loránd University and ELTE-Soft Ltd.
%%% are Copyright 2007-2025 Eötvös Loránd University, ELTE-Soft Ltd.
%%% and Ericsson Hungary. All Rights Reserved.


%%% @doc Unit test for {@link reflib_map_key}.
%%% @author Sandor Varga <vasa@caesar.elte.hu>

-module(reftest_reflib_map_key).
-vsn("$Rev: $").

-compile([export_all]).

-include("test.hrl").

files() ->
[{module, "map.erl",
	      "-module(map).    \n"
	      "-export([run/0]).\n"
	      "run() ->\n"
	      "Person = #{name=>\"Test1\", age=>24, phone=>\"999-9999\"},\n"
	      "Person#{name => \"Test2\"}.\n"
	     }].

test_form() ->
    Form = ?Query:exec1(?Query:seq([?Mod:find(map), 
				    ?Mod:local(run, 0), 
				    ?Fun:definition()]), form_not_found),
    Map = ?Query:exec1(Form, ?Form:maps(), map_not_found),
    [FstKey|_] = ?Query:exec(Map, ?Map:keys()),
    Form  = ?Query:exec1(FstKey, ?MapKey:funform(), function_not_found),
    ok.

test_map() ->
    Map = ?Query:exec1(?Query:seq([?Mod:find(map), 
				   ?Mod:local(run, 0), 
				   ?Fun:definition(), 
				   ?Form:maps()]), map_not_found),
    [FstKey|_] = ?Query:exec(Map, ?Map:keys()),
    Map = ?Query:exec1(FstKey, ?MapKey:map(), map_not_found),
    ok.

test_def() ->
    Map = ?Query:exec1(?Query:seq([?Mod:find(map), 
				   ?Mod:local(run, 0), 
				   ?Fun:definition(), 
				   ?Form:maps()]), map_not_found),
    [FstKey|_] = ?Query:exec(Map, ?Map:keys()),
    KeyDef = ?Query:exec1(FstKey, ?MapKey:keydef(), no_key_expr),
    FstKey = ?Query:exec1(KeyDef, ?Expr:keydefs(), no_key),
    ok.

test_ref() ->
    Map = ?Query:exec1(?Query:seq([?Mod:find(map), 
				   ?Mod:local(run, 0), 
				   ?Fun:definition(), 
				   ?Form:maps()]), map_not_found),
    [FstKey|_] = ?Query:exec(Map, ?Map:keys()),
    KeyRef = ?Query:exec1(FstKey, ?MapKey:references(), no_key_expr),
    FstKey = ?Query:exec1(KeyRef, ?Expr:keyrefs(), no_key),
    ok.
