%%% This file is part of RefactorErl.
%%%
%%% RefactorErl is free software: you can redistribute it and/or modify
%%% it under the terms of the GNU Lesser General Public License as published
%%% by the Free Software Foundation, either version 3 of the License, or
%%% (at your option) any later version.
%%%
%%% RefactorErl is distributed in the hope that it will be useful,
%%% but WITHOUT ANY WARRANTY; without even the implied warranty of
%%% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%%% GNU Lesser General Public License for more details.
%%%
%%% You should have received a copy of the GNU Lesser General Public License
%%% along with RefactorErl.  If not, see <http://plc.inf.elte.hu/erlang/>.
%%%
%%% The Original Code is RefactorErl.
%%%
%%% The Initial Developer of the Original Code is Eötvös Loránd University.
%%% Portions created  by Eötvös Loránd University and ELTE-Soft Ltd.
%%% are Copyright 2007-2025 Eötvös Loránd University, ELTE-Soft Ltd.
%%% and Ericsson Hungary. All Rights Reserved.


%%% ============================================================================
%%% Module information

%%% @doc Slicer supervisor.
%%%
%%% @author Istvan Bozo <bozo_i@inf.elte.hu>


-module(refsc_sup).

-vsn("$Rev: 17551 $ ").

-behaviour(supervisor).

%% API
-export([start/2, stop/1]).

%% Callbacks
-export([init/1]).

-define(CFGSrv, refsc_cfg_server).

-define(CDGSrv, refsc_cdg_server).

%% @private
start(normal, _Args)->
    supervisor:start_link({local, ?MODULE}, ?MODULE, []).

%% @private
stop(_) ->
    ok.

%% @private
init([]) ->
    % Description of the CFG server
    CFGServer =
        {?CFGSrv, {?CFGSrv, start_link, []},
         permanent, brutal_kill, worker, [?CFGSrv]},

    % Description of the CDG server
    CDGServer =
        {?CDGSrv, {?CDGSrv, start_link, []},
         permanent, brutal_kill, worker, [?CDGSrv]},

    Children = [CFGServer, CDGServer],
    RestartStrat = {one_for_all, 0, 1},
    {ok, {RestartStrat, Children}}.
