%%% This file is part of RefactorErl.
%%%
%%% RefactorErl is free software: you can redistribute it and/or modify
%%% it under the terms of the GNU Lesser General Public License as published
%%% by the Free Software Foundation, either version 3 of the License, or
%%% (at your option) any later version.
%%%
%%% RefactorErl is distributed in the hope that it will be useful,
%%% but WITHOUT ANY WARRANTY; without even the implied warranty of
%%% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%%% GNU Lesser General Public License for more details.
%%%
%%% You should have received a copy of the GNU Lesser General Public License
%%% along with RefactorErl.  If not, see <http://plc.inf.elte.hu/erlang/>.
%%%
%%% The Original Code is RefactorErl.
%%%
%%% The Initial Developer of the Original Code is Eötvös Loránd University.
%%% Portions created  by Eötvös Loránd University and ELTE-Soft Ltd.
%%% are Copyright 2007-2025 Eötvös Loránd University, ELTE-Soft Ltd.
%%% and Ericsson Hungary. All Rights Reserved.


%%% ============================================================================
%%% Module information

%%% @doc Test case selection helper module.
%%%
%%% @author Melinda Toth <tothmelinda@caesar.elte.hu>

-module(refsc_qc).

-vsn("$Rev: 17551 $ ").

-export([qc_props_form_exprs/1]).

-include("slicer.hrl").

qc_props_form_exprs(List)->
    qc_props_form_exprs(List, [], find_eqc_mods()).

qc_props_form_exprs([H | Tail], Acc, EqcMods)->
    case qc_prop(H, EqcMods) of
        false -> qc_props_form_exprs(Tail, Acc, EqcMods);
        Fun   -> qc_props_form_exprs(Tail, [Fun | Acc], EqcMods)
    end;
qc_props_form_exprs([], Acc, _) ->
    Acc.

qc_prop(Expr, EqcMods)->
    [Fun] = ?Graph:path(Expr, [top, {visib, back}, scope, functx, 
                               {funcl, back}, fundef]) ++ 
            ?Graph:path(Expr, [top, {name, back}, {funcl, back}, fundef]),
    FunCallMods = ?Graph:path(Fun, [funcall, {func, back}]),
    case ?MISC:intersect(FunCallMods, EqcMods) of
        [] -> false;
        _  -> Fun
    end.

find_eqc_mods()->
    case application:load(eqc) of
        ok -> {ok, Mods} = application:get_key(eqc, modules), Mods;
        {_, {already_loaded, _}} -> 
            {ok, Mods} = application:get_key(eqc, modules), Mods;
        _ ->
            Mods = [eqc, eqc_catch, eqc_ct, eqc_dialogues, eqc_expiry, 
                    eqc_fsm, eqc_fsm_callbacks, eqc_gen,eqc_lazy_lists,
                    eqc_memoize, eqc_messenger, eqc_random, eqc_sets,
                    eqc_socket, eqc_statem,matrix]
    end,
    lists:append(lists:map(fun(M)-> 
                               ?Graph:path(?Graph:root(), 
                                           [{module, {name, '==', M}}]) 
                           end, Mods)).


