%%% This file is part of RefactorErl.
%%%
%%% RefactorErl is free software: you can redistribute it and/or modify
%%% it under the terms of the GNU Lesser General Public License as published
%%% by the Free Software Foundation, either version 3 of the License, or
%%% (at your option) any later version.
%%%
%%% RefactorErl is distributed in the hope that it will be useful,
%%% but WITHOUT ANY WARRANTY; without even the implied warranty of
%%% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%%% GNU Lesser General Public License for more details.
%%%
%%% You should have received a copy of the GNU Lesser General Public License
%%% along with RefactorErl.  If not, see <http://plc.inf.elte.hu/erlang/>.
%%%
%%% The Original Code is RefactorErl.
%%%
%%% The Initial Developer of the Original Code is Eötvös Loránd University.
%%% Portions created  by Eötvös Loránd University and ELTE-Soft Ltd.
%%% are Copyright 2007-2025 Eötvös Loránd University, ELTE-Soft Ltd.
%%% and Ericsson Hungary. All Rights Reserved.


%%% ============================================================================
%%% Module information

%%% @doc This module contains properties which can be checked with QuickCheck.

%%% @author Ely Deckers <e.deckers@student.ru.nl>
-module(refqc_tc_props_eqc).

-vsn("$Rev: 17551 $").

-export([prop1/0,generator/0,comparison/1]).

-include_lib("referl_qc/include/prop_based_testing.hrl").
-include_lib("referl_qc/include/qc.hrl").

-author("Ely Deckers <e.deckers@student.ru.nl>").

%% @spec prop1() -> bool()
%%
%% @doc ForAll generated modules [X1,X2,...,Xn] that are loaded into RefErl as
%%[Y1,Y2,...,Yn]: SyntaxTree(Xi) == SyntaxTree(Yi).
prop1() ->
	?FORALL(FileName,?LAZY(generator()),comparison(FileName)).

%%% ============================================================================
%%% Helper functions
%%%

%% @spec generator() -> string()
%%
%% @doc Generates random code, and loads the result into RefErl.
generator() ->
	%generate file
	FileName = ?File:abs_path(?QCTCGEN:genfile()),

	%load it into RefErl.
	?UI:add(FileName),

	FileName.

%% @spec comparison(string()) -> true | false
%%
%% @doc Compares an Erlang source to the current RefErl db.
comparison(FileName) ->
	Result = ?QCTCCOMPARE:start(FileName),

	?UI:drop(FileName),

	Result.
