%%% This file is part of RefactorErl.
%%%
%%% RefactorErl is free software: you can redistribute it and/or modify
%%% it under the terms of the GNU Lesser General Public License as published
%%% by the Free Software Foundation, either version 3 of the License, or
%%% (at your option) any later version.
%%%
%%% RefactorErl is distributed in the hope that it will be useful,
%%% but WITHOUT ANY WARRANTY; without even the implied warranty of
%%% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%%% GNU Lesser General Public License for more details.
%%%
%%% You should have received a copy of the GNU Lesser General Public License
%%% along with RefactorErl.  If not, see <http://plc.inf.elte.hu/erlang/>.
%%%
%%% The Original Code is RefactorErl.
%%%
%%% The Initial Developer of the Original Code is Eötvös Loránd University.
%%% Portions created  by Eötvös Loránd University and ELTE-Soft Ltd.
%%% are Copyright 2007-2025 Eötvös Loránd University, ELTE-Soft Ltd.
%%% and Ericsson Hungary. All Rights Reserved.


%%% ============================================================================
%%% Module information

%%% @doc This module puts a trace of the code being compared in a logfile.

%%% @author Ely Deckers <e.deckers@student.ru.nl>
-module(refqc_tc_logger).

-vsn("$Rev: 17551 $").

-export([clear/0,append/1,writepath/3]).

-author("Ely Deckers <e.deckers@student.ru.nl>").

%% @spec clear() -> ok | {error,What}
%%
%% @doc Empty the log file.
clear() ->
    {ok, Handle} = file:open("log.txt", [raw, write]),
    file:close(Handle).

%% @spec append(string()) -> ok | {error,What}
%%
%% @doc Append data to the log file.
append(Data) ->
    {ok, Handle} = file:open("log.txt", [raw, append]),
    file:write(Handle,Data),
    file:write(Handle,"\n"),
    file:close(Handle).

%% @spec writepath(Func::string(),ReferlScope::list(),
%% ErlSyntax::syntaxTree()) -> ok | {error,What}
%%
%% @doc Add a path to the log file.
%%
%% @todo Implement.
writepath(Func,ReferlScope,ErlSyntax) ->
    X = Func,
	% next line should be written to log rather than screen
	io:write("~nScope:~p~nErlSyntax:~p",[ReferlScope,ErlSyntax]),
    append(X).
