%%% This file is part of RefactorErl.
%%%
%%% RefactorErl is free software: you can redistribute it and/or modify
%%% it under the terms of the GNU Lesser General Public License as published
%%% by the Free Software Foundation, either version 3 of the License, or
%%% (at your option) any later version.
%%%
%%% RefactorErl is distributed in the hope that it will be useful,
%%% but WITHOUT ANY WARRANTY; without even the implied warranty of
%%% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%%% GNU Lesser General Public License for more details.
%%%
%%% You should have received a copy of the GNU Lesser General Public License
%%% along with RefactorErl.  If not, see <http://plc.inf.elte.hu/erlang/>.
%%%
%%% The Original Code is RefactorErl.
%%%
%%% The Initial Developer of the Original Code is Eötvös Loránd University.
%%% Portions created  by Eötvös Loránd University and ELTE-Soft Ltd.
%%% are Copyright 2007-2025 Eötvös Loránd University, ELTE-Soft Ltd.
%%% and Ericsson Hungary. All Rights Reserved.


%%% ============================================================================
%%% Module information

%%% @doc This module  compares  the functions of an Erlang  syntax  tree to
%%% a  RefactorErl database.

%%% @author Ely Deckers <e.deckers@student.ru.nl>
-module(refqc_tc_funcs).

-include_lib("referl_qc/include/qc.hrl").

-vsn("$Rev: 17551 $").

-export([referl_eq/4]).

-author("Ely Deckers <e.deckers@student.ru.nl>").

%% @spec referl_eq(Scope::list(),Name::atom(),
%% Arity::integer(),Node::syntaxTree()) -> bool()
%%
%% @doc Verify that the Function parsed by Erlang is the same as the one in
%% the database.
referl_eq(Scope,Name,Arity,Node) ->
    FunExists = referl_exists(Scope,Name,Arity),
    if FunExists ->
        [NewScope] = ?Query:exec(Scope,
                        ?Query:seq([
                            ?Fun:find(Name,Arity),
                            ?Fun:definition(),
                            ?Form:clauses()])),
        SubTree = erl_syntax:function_clauses(Node),
        ?QCTCCOMPARE:traverse(NewScope,SubTree);
    true ->
        false
    end.

%% @private
%%
%% @spec referl_exists(Scope::list(),Name::atom(),Arity::integer()) -> bool()
%%
%% @doc Verify that a particular function exists in the Referl database.
referl_exists(Scope,Name,Arity) ->
    [Node] = ?Query:exec(Scope,?Fun:find(Name,Arity)),
    F = ?Fun:name(Node),
    A = ?Fun:arity(Node),
    ((Name==F) and (Arity==A)).
