%%% This file is part of RefactorErl.
%%%
%%% RefactorErl is free software: you can redistribute it and/or modify
%%% it under the terms of the GNU Lesser General Public License as published
%%% by the Free Software Foundation, either version 3 of the License, or
%%% (at your option) any later version.
%%%
%%% RefactorErl is distributed in the hope that it will be useful,
%%% but WITHOUT ANY WARRANTY; without even the implied warranty of
%%% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%%% GNU Lesser General Public License for more details.
%%%
%%% You should have received a copy of the GNU Lesser General Public License
%%% along with RefactorErl.  If not, see <http://plc.inf.elte.hu/erlang/>.
%%%
%%% The Original Code is RefactorErl.
%%%
%%% The Initial Developer of the Original Code is Eötvös Loránd University.
%%% Portions created  by Eötvös Loránd University and ELTE-Soft Ltd.
%%% are Copyright 2007-2025 Eötvös Loránd University, ELTE-Soft Ltd.
%%% and Ericsson Hungary. All Rights Reserved.


%%% ============================================================================
%%% Module information

%%% @doc This module  compares  the attributes of an Erlang  syntax  tree to
%%% a  RefactorErl database.

%%% @author Ely Deckers <e.deckers@student.ru.nl>

-module(refqc_tc_attribs).

-vsn("$Rev: 17551 $").

-include_lib("referl_qc/include/qc.hrl").

-export([referl_eq/3]).

-author("Ely Deckers <e.deckers@student.ru.nl>").

%% @spec referl_eq(Scope::list(),Type::atom(),Value::list()) -> bool()
%%
%% @doc Validate a particular attribute of a file.
referl_eq(_,module,Value) ->
    %find the module
    [Name] = ?Query:exec(?Mod:find(Value)),

    %check that Name contains exactly the same name as Value.
    (?Mod:name(Name) == Value);
referl_eq(Scope,export,Value) ->
    %get the nodes of functions that are exported.
    Nodes = [ ?Query:exec(Scope,?Mod:exported(F,A)) || {F,A} <- Value ],

    %retrieve names and arities of exported functions and put them in a
    %list with elements of form {Name,Arity}.
    Funcs = [ {?Fun:name(Node),?Fun:arity(Node)} || [Node] <- Nodes],

    %order the initial export list, and the one just generated, compare
    %them and return the result.
    (lists:sort(Funcs) == lists:sort(Value));
referl_eq(_,_,_) ->
    false.
