%%% This file is part of RefactorErl.
%%%
%%% RefactorErl is free software: you can redistribute it and/or modify
%%% it under the terms of the GNU Lesser General Public License as published
%%% by the Free Software Foundation, either version 3 of the License, or
%%% (at your option) any later version.
%%%
%%% RefactorErl is distributed in the hope that it will be useful,
%%% but WITHOUT ANY WARRANTY; without even the implied warranty of
%%% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%%% GNU Lesser General Public License for more details.
%%%
%%% You should have received a copy of the GNU Lesser General Public License
%%% along with RefactorErl.  If not, see <http://plc.inf.elte.hu/erlang/>.
%%%
%%% The Original Code is RefactorErl.
%%%
%%% The Initial Developer of the Original Code is Eötvös Loránd University.
%%% Portions created  by Eötvös Loránd University and ELTE-Soft Ltd.
%%% are Copyright 2007-2025 Eötvös Loránd University, ELTE-Soft Ltd.
%%% and Ericsson Hungary. All Rights Reserved.

%%% ============================================================================
%%% Module information
%%% @doc 
%%% @author D�niel Horp�csi <daniel_h@inf.elte.hu>

-module(refqc_elim_var).
-vsn("$Rev: $").

%% Random module based testing callbacks
-export([prepare/1, perform_and_check/2]).
%% Interface
-export([prop_eliminate_var/0]).

-include_lib("referl_qc/include/prop_based_testing.hrl").
-include_lib("referl_qc/include/qc.hrl").

prop_eliminate_var() ->
    Files = ?QCCOMMON:get_files_in_database(),
    ?FORALL(Args, ?LAZY(?QCGEN:gen_args(elimvar, {files, Files})), %% TODO: likely crashes
            perform_and_check({files, Files}, Args)).

%% =============================================================================
%% Random module based testing callbacks

prepare(Mods) -> ?LAZY(?QCGEN:gen_args(elimvar, {modules, Mods})).

perform_and_check(_ModsOrFiles, {_, _, Args}) ->
    FilePath = ?QCCOMMON:get_file(Args),
    CompResultBefore = compile:file(FilePath, [strong_validation, return_errors]),
    
    %% OptionList = [{call_depth, 0}, {canonical, true}], % todo: maybe not so hard-coded :)
    %% SemTreesBefore = ?QCCOMMON:generate_semtrees(Files, OptionList),
    
    Result = reftest_utils:exec_transform(elim_var, Args),
    
    case Result of
        {result, _, _} ->
            ?QCCOMMON:prop_compile(FilePath, CompResultBefore);
        %% andalso ?QCCOMMON:prop_semtree(SemTreesBefore, Files, OptionList);
        {abort,{_ErrorDesc, ErrorMessage}} ->
            io:format("Transformation aborted:~n\t~s~n", [ErrorMessage]),
            true
    end.
