%%% This file is part of RefactorErl.
%%%
%%% RefactorErl is free software: you can redistribute it and/or modify
%%% it under the terms of the GNU Lesser General Public License as published
%%% by the Free Software Foundation, either version 3 of the License, or
%%% (at your option) any later version.
%%%
%%% RefactorErl is distributed in the hope that it will be useful,
%%% but WITHOUT ANY WARRANTY; without even the implied warranty of
%%% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%%% GNU Lesser General Public License for more details.
%%%
%%% You should have received a copy of the GNU Lesser General Public License
%%% along with RefactorErl.  If not, see <http://plc.inf.elte.hu/erlang/>.
%%%
%%% The Original Code is RefactorErl.
%%%
%%% The Initial Developer of the Original Code is Eötvös Loránd University.
%%% Portions created  by Eötvös Loránd University and ELTE-Soft Ltd.
%%% are Copyright 2007-2025 Eötvös Loránd University, ELTE-Soft Ltd.
%%% and Ericsson Hungary. All Rights Reserved.


%%% @doc Map key properties and map key based queries

-module(reflib_map_key).
-vsn("$Rev: $"). % for emacs"

%% =============================================================================
%% Exports

-export([id/1, funform/0, mapdef/0, keydef/0, references/0, map/0]).

-include("lib.hrl").

%% =============================================================================

%% @spec id(node(#mapkey{})) -> integer()
%% @doc The id of the key object
id(Key) ->
    (?Graph:data(Key))#mapkey.id.

%% @spec funform() -> query(#mapkey{}, #form{})
%% @doc The result query returns the function form that defines the map
funform() ->
    [{key, back}, {map, back}].

%% @spec mapdef() -> query(#mapkey{}, #expr{})
%% @doc The result query returns the expression that defines the map
mapdef() ->
    [{key, back}, {mapdef, back}].

%% @spec map() -> query(#mapkey{}, #map{})
%% @doc The result query returns the defining map of the map key
map() ->
    [{key, back}].

%% @spec keydef() -> query(#mapkey{}, #expr{})
%% @doc The result query returns the expression that defines the key
keydef() ->
    [{keydef, back}].

%% @spec references() -> query(#mapkey{}, #expr{})
%% @doc The result query returns the references to the map key
references() ->
    [{keyref, back}].

