Nonterminals

  grammar declaration rule symbol symbols strings attached_code token
  tokens lhs rhs rhs_elem_base rule_end nested_rule real_rhs argument
  arguments app attrmanip attrsets attrset freq guard guard_body
  guard_name log_op ruleset rules.

Terminals

  atom float integer reserved_symbol reserved_word string char var
  '->' dot '(' ')' '*' '{' '}' 'when' ',' '@' '~' '\\' '::' '=' '&'
  '?' '>' '<!' '!>' 'and' 'or' 'andalso' 'orelse'.

Rootsymbol grammar.

Left 200 'and'.
Left 200 'andalso'.
Left 100 'or'.
Left 100 'orelse'.

grammar -> declaration : '$1'.
grammar -> ruleset : '$1'.

declaration -> symbol symbols dot: {'$1', '$2'}.
declaration -> symbol strings dot: {'$1', '$2'}.

ruleset -> lhs '->' rules : {ruleset, '$1', '$3'}.

lhs -> symbol : '$1'.
lhs -> app  : '$1'.

rules -> rule dot : ['$1'].
rules -> rule '\\' rules : ['$1' | '$3'].

rule -> freq guard rhs rule_end :
    {rule, '$1', '$2', '$3', element(1, '$4'), element(2, '$4')}.
rule -> freq guard rhs rule_end '~' '>' nested_rule :
    {rule, '$1', '$2', '$3', element(1, '$4'), element(2, '$4'), '$7'}.

nested_rule -> rhs rule_end :
    {rule, {}, {}, '$1', element(1, '$2'), element(2, '$2')}.
nested_rule -> rhs rule_end '~' '>' nested_rule :
    {rule, {}, {}, '$1', element(1, '$2'), element(2, '$2'), '$5'}.

rule_end -> '::' attached_code attrmanip : {'$2', '$3'}.
rule_end -> '$empty' : {[], []}.

freq -> '*' integer : '$2'.
freq -> '$empty' : {}.

guard -> '(' 'when' guard_body ')' : '$3'.
guard -> 'when' guard_body : '$2'.
guard -> '$empty' : {}.

guard_body -> guard_name : '$1'.
guard_body -> '(' guard_body ')' : '$2'.
guard_body -> guard_body log_op guard_body : {'$2', '$1', '$3'}.

guard_name -> lhs : '$1'.

log_op -> 'and'     : 'and'.
log_op -> 'or'      : 'or'.
log_op -> 'andalso' : 'andalso'.
log_op -> 'orelse'  : 'orelse'.

app -> symbol '(' arguments ')' : {app, '$1', '$3'}.

rhs -> '$empty' : [].
rhs -> real_rhs : '$1'.
real_rhs -> rhs_elem_base attrmanip : [{'$1', '$2'}].
real_rhs -> rhs_elem_base attrmanip '&' rhs : [{'$1', '$2'} | '$4'].
real_rhs -> rhs_elem_base real_rhs : [{'$1', []} | '$2'].

rhs_elem_base -> symbol : '$1'.
rhs_elem_base -> symbol '(' arguments ')' : {app, '$1', '$3'}.

rhs_elem_base -> '{'                  rhs_elem_base '}' : {ind_list, '$2'}.
rhs_elem_base -> '{' argument ','     rhs_elem_base '}' : {ind_list, '$2', '$4'}.
rhs_elem_base -> '{' '~'              rhs_elem_base '}' : {dep_list, '$3'}.
rhs_elem_base -> '{' '~' argument ',' rhs_elem_base '}' : {dep_list, '$3', '$5'}.

attrmanip -> '$empty' : [].
attrmanip -> '<!' attrsets '!>' : '$2'.
attrsets -> attrset : ['$1'].
attrsets -> attrset '@' attrsets : ['$1' | '$3'].
attrset -> atom '=' tokens : {'$1', '$3'}.

attached_code -> tokens : '$1'.
attached_code -> '$empty' : [].

symbols -> symbol : ['$1'].
symbols -> symbol symbols : ['$1' | '$2'].

strings -> string : ['$1'].
strings -> string strings : ['$1' | '$2'].

symbol -> var : symbol('$1').
symbol -> atom : symbol('$1').
symbol -> integer : symbol('$1').
symbol -> reserved_word : symbol('$1').

arguments -> '$empty' : [].
arguments -> argument : ['$1'].
arguments -> argument ',' arguments : ['$1' | '$3'].

argument -> var : '$1'.
argument -> atom : '$1'.
argument -> float : '$1'.
argument -> integer : '$1'.
argument -> string : '$1'.
argument -> char : '$1'.
argument -> app : '$1'.
argument -> '?' symbol : {macro, '$2'}.
argument -> '?' symbol '(' arguments ')' : {macro, '$2', '$4'}.

tokens -> token : ['$1'].
tokens -> token tokens : ['$1' | '$2'].

token -> var : '$1'.
token -> atom : '$1'.
token -> float : '$1'.
token -> integer : '$1'.
token -> string : '$1'.
token -> char : '$1'.
token -> reserved_symbol : {value_of('$1'), line_of('$1')}.
token -> reserved_word : {value_of('$1'), line_of('$1')}.
token -> '->'      : {'->', line_of('$1')}.
token -> '('       : {'(', line_of('$1')}.
token -> ')'       : {')', line_of('$1')}.
token -> '*'       : {'*', line_of('$1')}.
token -> '{'       : {'{', line_of('$1')}.
token -> '}'       : {'}', line_of('$1')}.
token -> 'when'    : {'when', line_of('$1')}.
token -> ','       : {',', line_of('$1')}.
token -> '='       : {'=', line_of('$1')}.
token -> '?'       : {'?', line_of('$1')}.
token -> '>'       : {'>', line_of('$1')}.
token -> 'and'     : {'and', line_of('$1')}.
token -> 'or'      : {'or', line_of('$1')}.
token -> 'andalso' : {'andalso', line_of('$1')}.
token -> 'orelse'  : {'orelse', line_of('$1')}.

Erlang code.

-record(symbol, {line, name}).

symbol(Symbol) ->
    #symbol{line = line_of(Symbol), name = value_of(Symbol)}.

value_of(Token) ->
    element(3, Token).

line_of(Token) ->
    element(2, Token).
