-module(fibonacci).
-include_lib("eunit/include/eunit.hrl").
-export([fib/1]).

fib(0) ->
    1;
fib(1) ->
    1;
fib(N) when N > 1 ->
    fib(N-1) + fib(N-2).

f_test_() ->
    [?_assertEqual(1, fibonacci:fib(0)),
     ?_assertError(function_clause, fibonacci:fib(-1)),
     ?_assert(8 =:= fibonacci:fib(5))].

f0_test()->
    ?assertEqual(1,fibonacci:fib(0)).

ferror_test()->
    ?assertError(function_clause, fibonacci:fib(-1)).

fassert_test()->
    ?assert(8 =:= fibonacci:fib(5)).
