-module(test).
-export([init/1]).

init(Time) ->
    loop({Time, empty(), empty()}).

loop({Time, P, OP}) ->
    receive
        {next} ->
            do_next({Time, P, OP});
        {get, From, Key} ->
            do_get({Time, P, OP}, From, Key);
        {set, Key, Value} ->
            do_set({Time, P, OP}, Key, Value)
    end.

do_next({peak,P, OP}) ->
    loop({offp, P, OP});
do_next({offp,P, OP}) ->
    loop({peak, P, OP}).

do_get({peak, P, OP}, From, Key) ->
    get_value(From, P, Key),
    loop({offp, P, OP});
do_get({offp, P, OP}, From, Key) ->
    get_value(From, OP, Key),
    loop({peak, P, OP}).

do_set({peak, P, OP}, Key, Value) ->
    NewSt = set_value(P, Key, Value),
    loop({offp, NewSt, OP});
do_set({offp, P, OP}, Key, Value) ->
    NewSt = set_value(P, Key, Value),
    loop({peak, NewSt, OP}).

empty() ->
    [].

get_value(_, _, _) ->
    ok.

set_value(_, _, _) ->
    ok.
