-module(test).
-export([init/1]).
-record(state, {time, stP, stOP}).

init(Time) ->
    loop(#state{time=Time, stP=empty(), stOP=empty()}).

loop(X = #state{}) ->
    receive
        {next} ->
            do_next(X);
        {get, From, Key} ->
            do_get(X, From, Key);
        {set, Key, Value} ->
            do_set(X, Key, Value)
    end.

do_next(X = #state{time=peak}) ->
    loop(X#state{time=offp});
do_next(X = #state{time=offp}) ->
    loop(X#state{time=peak}).

do_get(X = #state{time=peak, stP=P}, From, Key) ->
    get_value(From, P, Key),
    loop(X#state{time=offp});
do_get(X = #state{time=offp, stOP=OP}, From, Key) ->
    get_value(From, OP, Key),
    loop(X#state{time=peak}).

do_set(X = #state{time=peak, stP=P}, Key, Value) ->
    NewSt = set_value(P, Key, Value),
    loop(X#state{time=offp, stP=NewSt});
do_set(X = #state{time=offp, stP=P}, Key, Value) ->
    NewSt = set_value(P, Key, Value),
    loop(X#state{time=peak, stP=NewSt}).

empty() ->
    [].

get_value(_, _, _) ->
    ok.

set_value(_, _, _) ->
    ok.
