-module(mpt2).
-export([integrate/2,increase_both/1,invocations/0]).

min({X,Y}) -> if
                 X <  Y -> X;
                 X >= Y -> Y
              end.

integrate(F,{A,B}) -> 
    (F(A) + F(B)) / 2.0 * (B - A).

increase_both({{X,D1},{Y,D2}}) -> {X+D1,Y+D2}.

swap({A,B}) -> {B,A}.

gcd({A, 0}) -> A;
gcd({A, B}) -> gcd({B, A rem B}).

invocations() -> 
  I = integrate(fun(X) -> X end, {0, 1}),
  {S1,S2} = swap({3,I}),
  Z = increase_both({{S1,S2},
            swap({lists:max([S1,S2]),1})}),
  V = increase_both({{1,1},{2,3}}),
  A = integrate(fun(X) -> S1+X end, {0, 1}),
  D = gcd({6,9}),
  min({A+D,min({min(V),min(Z)})}).

