-module(client).
-export([start/1, input/1]).

-define(Name, job_server).

start(Client)->
    spawn_link(?MODULE, start_cl, [Client]).

start_cl(Client) ->
    ?Name ! {connect, Client},
    ets:new(data, [named_table, public]),
    spawn(?MODULE, input, [self()]),
    loop(data, Client).

loop(Tab, Name) ->
    receive
        quit ->
            ?Name ! {disconnect, Name},
            io:format("~p~n", [ets:match(Tab, {result, '$1'})]);
        {job, {Mod, Fun}} ->
            ?Name ! {do, Mod, Fun, Tab},
            loop(Tab, Name)
    end.

input(Loop) ->
    case read_input() of
        quit ->
            Loop ! quit,
            ok;
        Job ->
            Loop ! {job, Job},
            input(Loop)
    end.

read_input() ->
    init_table(data),
    {returns_the_job_to_be_executed, []}.

init_table(_Tab) ->
    initialize_the_ets_table.
